/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkram17.bazaarutils.features;

import com.github.mkram17.bazaarutils.config.BUConfig;
import com.github.mkram17.bazaarutils.config.BUConfigGui;
import com.github.mkram17.bazaarutils.events.handlers.BUListener;
import com.github.mkram17.bazaarutils.misc.orderinfo.BazaarOrder;
import com.github.mkram17.bazaarutils.misc.orderinfo.OrderInfoContainer;
import com.github.mkram17.bazaarutils.misc.orderinfo.PriceInfoContainer;
import com.github.mkram17.bazaarutils.utils.ScreenInfo;
import com.github.mkram17.bazaarutils.utils.Util;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import java.util.List;
import lombok.Generated;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_465;

public class OrderStatusHighlight
implements BUListener {
    private boolean enabled;
    public static final class_2960 IDENTIFIER = class_2960.method_43902((String)"bazaarutils", (String)"orderstatushighlight/background");
    public static final float BACKGROUND_TRANSPARENCY = 0.9f;

    public OrderStatusHighlight(boolean enabled) {
        this.enabled = enabled;
    }

    private static List<BazaarOrder> getHighlightedOrders() {
        return BUConfig.get().userOrders.stream().filter(order -> order.getItemInfo() != null && order.getItemInfo().slotIndex() != null && order.getFillStatus() == OrderInfoContainer.Statuses.SET).toList();
    }

    public static BazaarOrder getHighlightedOrder(int slotIndex) {
        return OrderStatusHighlight.getHighlightedOrders().stream().filter(order -> order.getItemInfo().slotIndex() == slotIndex).findFirst().orElse(null);
    }

    @Override
    public void subscribe() {
        this.registerTooltipListener();
    }

    public Option<Boolean> createOption() {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Order Status Highlight")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Adds a colored background and tooltip for orders that are competitive, matched or outbid in the orders gui inside the bazaar. For outdated orders, also adds the market price in the tooltip.")})).binding((Object)false, this::isEnabled, this::setEnabled).controller(BUConfigGui::createBooleanController).build();
    }

    private void registerTooltipListener() {
        ItemTooltipCallback.EVENT.register((stack, context, type, lines) -> {
            Object patt0$temp;
            if (!this.enabled) {
                return;
            }
            ScreenInfo screenInfo = ScreenInfo.getCurrentScreenInfo();
            if (stack == null || stack.method_7960() || stack.method_7909().method_63680().getString().contains("GLASS_PANE") || !screenInfo.inMenu(ScreenInfo.BazaarMenuType.ORDER_SCREEN)) {
                return;
            }
            class_310 client = class_310.method_1551();
            if (client.field_1724 == null || !((patt0$temp = client.field_1755) instanceof class_465)) {
                return;
            }
            class_465 handledScreen = (class_465)patt0$temp;
            for (Object line : lines) {
                String lineText = line.getString();
                if (!lineText.contains("FILLED") && !lineText.contains("OUTBID") && !lineText.contains("COMPETITIVE") && !lineText.contains("MATCHED")) continue;
                return;
            }
            int index = -1;
            for (class_1735 slot : handledScreen.method_17577().field_7761) {
                if (!slot.method_7681() || slot.method_7677() != stack) continue;
                index = slot.method_34266();
            }
            if (index == -1) {
                return;
            }
            BazaarOrder order = OrderStatusHighlight.getHighlightedOrder(index);
            if (order == null) {
                return;
            }
            OrderInfoContainer.Statuses orderStatus = order.getOutbidStatus();
            if (orderStatus == null) {
                return;
            }
            switch (orderStatus) {
                case OUTBID: {
                    lines.add(1, class_2561.method_43470((String)"OUTBID").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}));
                    lines.add(2, class_2561.method_43470((String)("Market Price: " + Util.getPrettyString(order.getMarketPrice(order.getPriceType())))).method_27692(class_124.field_1061));
                    break;
                }
                case COMPETITIVE: {
                    lines.add(1, class_2561.method_43470((String)"COMPETITIVE").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}));
                    break;
                }
                case MATCHED: {
                    lines.add(1, class_2561.method_43470((String)"MATCHED").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}));
                }
            }
            if (BUConfig.get().developerMode) {
                Double sellPrice = order.getMarketPrice(PriceInfoContainer.PriceType.INSTASELL);
                Double buyPrice = order.getMarketPrice(PriceInfoContainer.PriceType.INSTABUY);
                if (sellPrice == null || buyPrice == null) {
                    return;
                }
                lines.add(class_2561.method_43470((String)("[BU] Buy: " + Util.getPrettyString(sellPrice) + " coins")));
                lines.add(class_2561.method_43470((String)("[BU] Sell: " + Util.getPrettyString(buyPrice) + " coins")));
            }
        });
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

