/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkram17.bazaarutils.features;

import com.github.mkram17.bazaarutils.config.BUConfig;
import com.github.mkram17.bazaarutils.config.BUConfigGui;
import com.github.mkram17.bazaarutils.misc.orderinfo.BazaarOrder;
import com.github.mkram17.bazaarutils.misc.orderinfo.OrderInfoContainer;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class OutbidOrderHandler {
    private boolean autoOpenEnabled;
    private boolean notifyOutbid;
    private boolean notificationSound;

    public OutbidOrderHandler(boolean autoOpenEnabled, boolean notifyOutbid) {
        this.autoOpenEnabled = autoOpenEnabled;
        this.notifyOutbid = notifyOutbid;
        this.notificationSound = true;
    }

    public static class_5250 getOutbidMessage(BazaarOrder order) {
        return OutbidOrderHandler.createYourOrderForText(order).method_10852((class_2561)class_2561.method_43470((String)" is now outdated.").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" Click to open bazaar orders").method_27692(class_124.field_1065));
    }

    public static class_5250 getCompetitiveMessage(BazaarOrder order) {
        return OutbidOrderHandler.createYourOrderForText(order).method_10852((class_2561)class_2561.method_43470((String)" is no longer outdated.").method_27692(class_124.field_1064));
    }

    public static class_5250 getMatchedMessage(BazaarOrder order) {
        return OutbidOrderHandler.createYourOrderForText(order).method_10852((class_2561)class_2561.method_43470((String)" has been matched.").method_27692(class_124.field_1054));
    }

    private static class_5250 createYourOrderForText(BazaarOrder order) {
        return class_2561.method_43470((String)("Your " + order.getPriceType().getString().toLowerCase() + " order for ")).method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)(order.getVolume().toString() + " ")).method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)order.getName()).method_27692(class_124.field_1065));
    }

    public static List<BazaarOrder> getOutbidOrders() {
        return BUConfig.get().userOrders.stream().filter(order -> order.getOutbidStatus() == OrderInfoContainer.Statuses.OUTBID && order.getFillStatus() != OrderInfoContainer.Statuses.FILLED).toList();
    }

    public Collection<Option<Boolean>> createOptions() {
        ArrayList<Option<Boolean>> options = new ArrayList<Option<Boolean>>();
        options.add(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Open Bazaar on Outbid Orders")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Automatically open the bazaar after a delay when an order becomes outdated.")})).binding((Object)false, this::isAutoOpenEnabled, this::setAutoOpenEnabled).controller(BUConfigGui::createBooleanController).build());
        options.add(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Chat Notification on Outbid Orders")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Sends a message in chat when someone has undercut your order.")})).binding((Object)true, this::isNotifyOutbid, this::setNotifyOutbid).controller(BUConfigGui::createBooleanController).build());
        options.add(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Sound on Outbid Order")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Plays three short notification sounds when your order becomes outdated.")})).binding((Object)true, this::isNotificationSound, this::setNotificationSound).controller(BUConfigGui::createBooleanController).build());
        return options;
    }

    @Generated
    public boolean isAutoOpenEnabled() {
        return this.autoOpenEnabled;
    }

    @Generated
    public void setAutoOpenEnabled(boolean autoOpenEnabled) {
        this.autoOpenEnabled = autoOpenEnabled;
    }

    @Generated
    public boolean isNotifyOutbid() {
        return this.notifyOutbid;
    }

    @Generated
    public void setNotifyOutbid(boolean notifyOutbid) {
        this.notifyOutbid = notifyOutbid;
    }

    @Generated
    public boolean isNotificationSound() {
        return this.notificationSound;
    }

    @Generated
    public void setNotificationSound(boolean notificationSound) {
        this.notificationSound = notificationSound;
    }
}

