/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkram17.bazaarutils.utils;

import com.github.mkram17.bazaarutils.BazaarUtils;
import com.github.mkram17.bazaarutils.events.ScreenChangeEvent;
import com.github.mkram17.bazaarutils.utils.GUIUtils;
import com.github.mkram17.bazaarutils.utils.Util;
import java.util.function.Predicate;
import lombok.Generated;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1802;
import net.minecraft.class_437;

public class ScreenInfo {
    private static final ScreenInfo currentScreenInfo = new ScreenInfo();
    private static boolean initialized = false;
    private class_437 screen;
    private class_437 previousScreen;

    private ScreenInfo() {
    }

    public static void initialize(class_437 initialScreen) {
        if (initialized) {
            return;
        }
        ScreenInfo.currentScreenInfo.screen = initialScreen;
        BazaarUtils.EVENT_BUS.subscribe((Object)currentScreenInfo);
        initialized = true;
    }

    @EventHandler
    private void onScreenChange(ScreenChangeEvent event) {
        this.previousScreen = this.screen;
        this.screen = event.getNewScreen();
    }

    public ScreenInfo getPreviousScreenInfo() {
        if (this.previousScreen == null) {
            return null;
        }
        ScreenInfo prevInfo = new ScreenInfo();
        prevInfo.screen = this.previousScreen;
        return prevInfo;
    }

    public boolean inMenu(BazaarMenuType ... types) {
        for (BazaarMenuType bazaarMenuType : types) {
            if (!bazaarMenuType.matches(this)) continue;
            return true;
        }
        return false;
    }

    public boolean inBazaar() {
        return this.inMenu(BazaarMenuType.BUY_ORDER, BazaarMenuType.FLIP_GUI, BazaarMenuType.INSTA_BUY, BazaarMenuType.BAZAAR_MAIN_PAGE, BazaarMenuType.ORDER_SCREEN, BazaarMenuType.SELL_SETUP, BazaarMenuType.CONFIRM_SELL_OFFER, BazaarMenuType.CONFIRM_BUY_OFFER, BazaarMenuType.ORDER_PRICE, BazaarMenuType.ITEM_GROUP_PAGE, BazaarMenuType.INDIVIDUAL_ITEM);
    }

    public String getContainerName() {
        if (this.screen == null || this.screen.method_25440() == null) {
            return null;
        }
        return Util.removeFormatting(this.screen.method_25440().getString());
    }

    @Generated
    public static ScreenInfo getCurrentScreenInfo() {
        return currentScreenInfo;
    }

    @Generated
    public class_437 getScreen() {
        return this.screen;
    }

    public static enum BazaarMenuType {
        BUY_ORDER("How many do you want?"),
        INSTA_BUY("\u279c Insta"),
        ORDER_SCREEN("Bazaar Orders"),
        SELL_SETUP("At what price are you selling?"),
        CONFIRM_SELL_OFFER("Confirm Sell Offer"),
        CONFIRM_BUY_OFFER("Confirm Buy Order"),
        ORDER_PRICE("How much do you want to pay?"),
        FLIP_GUI("Order options"),
        BAZAAR_MAIN_PAGE("Bazaar \u279c "),
        BAZAAR_SETTINGS_PAGE("Settings"),
        ITEM_GROUP_PAGE(info -> {
            String name = info.getContainerName();
            if (name == null || !name.contains("\u279c")) {
                return false;
            }
            return !GUIUtils.getChestItem(34).method_7909().equals(class_1802.field_8732);
        }),
        INDIVIDUAL_ITEM(info -> {
            String name = info.getContainerName();
            if (name == null || !name.contains("\u279c")) {
                return false;
            }
            return GUIUtils.getChestItem(33).method_7909().equals(class_1802.field_8407);
        });

        private final String titleString;
        private final Predicate<ScreenInfo> matcher;

        private BazaarMenuType(String titleString) {
            this.titleString = titleString;
            this.matcher = info -> {
                String n = info.getContainerName();
                return n != null && n.contains(titleString);
            };
        }

        private BazaarMenuType(Predicate<ScreenInfo> matcher) {
            this.titleString = null;
            this.matcher = matcher;
        }

        public boolean matches(ScreenInfo info) {
            return this.matcher.test(info);
        }

        @Generated
        public String getTitleString() {
            return this.titleString;
        }
    }
}

