/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkram17.bazaarutils.utils;

import com.github.mkram17.bazaarutils.misc.autoregistration.RunOnInit;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import javax.swing.Timer;
import lombok.Generated;

public class TimeUtil {
    private static ZonedDateTime modInitTime;
    public static final ZonedDateTime LAST_BAZAAR_LIMIT_RESET_TIME;
    private static ZonedDateTime nextBazaarLimitReset;
    private static long timeToBazaarLimitReset;

    private static void updateTime() {
        modInitTime = ZonedDateTime.now(ZoneOffset.UTC);
        nextBazaarLimitReset = modInitTime.toLocalDate().plusDays(1L).atStartOfDay(ZoneOffset.UTC);
        timeToBazaarLimitReset = Duration.between(modInitTime, nextBazaarLimitReset).toSeconds();
    }

    @RunOnInit
    public static void startTimer() {
        TimeUtil.updateTime();
        Timer timer = new Timer(10000, e -> TimeUtil.updateTime());
        timer.setRepeats(true);
        timer.start();
    }

    @Generated
    public static ZonedDateTime getModInitTime() {
        return modInitTime;
    }

    @Generated
    public static ZonedDateTime getNextBazaarLimitReset() {
        return nextBazaarLimitReset;
    }

    @Generated
    public static long getTimeToBazaarLimitReset() {
        return timeToBazaarLimitReset;
    }

    static {
        LAST_BAZAAR_LIMIT_RESET_TIME = ZonedDateTime.of(LocalDate.now(ZoneOffset.UTC), LocalTime.MIDNIGHT, ZoneOffset.UTC);
    }
}

