package fr.lanfix.allhudbars.overlay;

import fr.lanfix.allhudbars.AllHudBars;
import java.util.Random;
import net.minecraft.class_10799;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_638;
import net.minecraft.class_8012;

public class HealthBar {

    final Random rng = new Random();

    private static final class_2960 fullHealthBar = class_2960.method_60655(AllHudBars.MOD_ID, "textures/gui/bars/health/full.png");
    private static final class_2960 witherHealthBar = class_2960.method_60655(AllHudBars.MOD_ID, "textures/gui/bars/health/wither.png");
    private static final class_2960 poisonHealthBar = class_2960.method_60655(AllHudBars.MOD_ID, "textures/gui/bars/health/poison.png");
    private static final class_2960 frozenHealthBar = class_2960.method_60655(AllHudBars.MOD_ID, "textures/gui/bars/health/frozen.png");
    private static final class_2960 intermediateHealthBar = class_2960.method_60655(AllHudBars.MOD_ID, "textures/gui/bars/health/intermediate.png");
    private static final class_2960 emptyHealthBar = class_2960.method_60655(AllHudBars.MOD_ID, "textures/gui/bars/health/empty.png");
    private static final class_2960 absorptionBar = class_2960.method_60655(AllHudBars.MOD_ID, "textures/gui/bars/health/absorption.png");

    private static final class_2960 heartContainer = class_2960.method_60655("minecraft", "textures/gui/sprites/hud/heart/container.png");
    private static final class_2960 absorptionHeart = class_2960.method_60655("minecraft", "textures/gui/sprites/hud/heart/absorbing_full.png");

    private class_2960 currentBar = fullHealthBar;
    private double intermediateHealth = 0;

    public void render(class_327 textRenderer, class_332 context, class_1657 player, int x, int y, float tickDelta) {
        updateBarTextures(player);
        // Only render absorption when necessary
        if (player.method_6067() > 0) {
            renderAbsorptionBar(context, x, y, player);
            renderAbsorptionValue(textRenderer, context, x, y, player);
        }
        // We need to render the health bar after because they overlap a little
        renderHealthBar(context, tickDelta, x, y, player);
        renderHealthValue(textRenderer, context, x, y, player);
    }

    public void updateBarTextures(class_1657 player) {
        if (player.method_6059(class_1294.field_5920)) {
            currentBar = witherHealthBar;
        } else if (player.method_6059(class_1294.field_5899)) {
            currentBar = poisonHealthBar;
        } else if (player.method_32314()) {
            currentBar = frozenHealthBar;
        } else {
            currentBar = fullHealthBar;
        }
    }

    private void renderHealthValue(class_327 textRenderer, class_332 context, int x, int y, class_1657 player) {
        double health = Math.ceil(player.method_6032() * 10) / 10;
        float maxHealth = player.method_6063();
        String text = health + "/" + (int) player.method_6063();
        text = text.replace(".0", "");

        // Shake sprite and value and color value red when <=20% health
        boolean isLowHealth = health / maxHealth <= 0.2;

        // Color value green when regen
        boolean playerHasRegen = player.method_6059(class_1294.field_5924)
                || player.method_6059(class_1294.field_5915);

        // Show a special string on the death screen (different if in hardcore)
        if (health <= 0) {
            class_638 world = class_310.method_1551().field_1687;
            if (world != null) {
                boolean isHardcore = world.method_28104().method_152();
                text = class_2561.method_43471("gui.allhudbars.zero_health" + (isHardcore ? ".hardcore" : "")).getString();
            }
        }

        // Offset for text
        int offX = 4;
        int offY = -4;
        // Cause the value to shake when low health
        if (isLowHealth && health > 0)
            offY += rng.nextInt(-1, 2);

        // The health color: White when normal, pink when low health, green when regen (even if low health)
        int healthColor = class_8012.field_42973;
        if (isLowHealth)
            healthColor = class_8012.field_60979;
        if (playerHasRegen)
            healthColor = class_8012.field_52312;

        // Draw health value + 4px outline
        context.method_51433(textRenderer, text, x + offX + 1, y + offY, class_8012.field_42974, false);
        context.method_51433(textRenderer, text, x + offX - 1, y + offY, class_8012.field_42974, false);
        context.method_51433(textRenderer, text, x + offX, y + offY + 1, class_8012.field_42974, false);
        context.method_51433(textRenderer, text, x + offX, y + offY - 1, class_8012.field_42974, false);
        context.method_51433(textRenderer, text, x + offX, y + offY, healthColor, false);

    }

    private void renderHealthBar(class_332 context, float tickDelta, float x, float y, class_1657 player) {
        float health = player.method_6032();
        float maxHealth = player.method_6063();

        // Calculate bar proportions
        double healthProportion;
        double intermediateProportion;
        if (health < intermediateHealth) {
            healthProportion = health / maxHealth;
            intermediateProportion = (intermediateHealth - health) / maxHealth;
        } else {
            healthProportion = intermediateHealth / maxHealth;
            intermediateProportion = 0;
        }
        if (healthProportion > 1) healthProportion = 1F;
        if (healthProportion + intermediateProportion > 1) intermediateProportion = 1 - healthProportion;
        int healthWidth = (int) Math.ceil(80 * healthProportion);
        int intermediateWidth = (int) Math.ceil(80 * intermediateProportion);

        // Display full part
        context.method_25290(class_10799.field_56883, currentBar,
                (int) x, (int) y,
                0, 0,
                healthWidth, 9,
                80, 9);

        // Display intermediate part
        context.method_25290(class_10799.field_56883, intermediateHealthBar,
                (int) x + healthWidth, (int) y,
                healthWidth, 0,
                intermediateWidth, 9,
                80, 9);

        // Display empty part
        context.method_25290(class_10799.field_56883, emptyHealthBar,
                (int) x + healthWidth + intermediateWidth, (int) y,
                healthWidth + intermediateWidth, 0,
                80 - healthWidth - intermediateWidth, 9,
                80, 9);

        // Update intermediate health
        this.intermediateHealth += (health - intermediateHealth) * tickDelta * 0.08;
        if (Math.abs(health - intermediateHealth) <= 0.25) {
            this.intermediateHealth = health;
        }
    }

    private void renderAbsorptionValue(class_327 textRenderer, class_332 context, int x, int y, class_1657 player) {
        double absorption = Math.ceil(player.method_6067() * 10) / 10;
        String text = String.valueOf(absorption);
        text = text.replace(".0", "");

        // Offset of sprite
        int offX = 1;
        int offY = -15;

        // blit heart container
        context.method_25290(class_10799.field_56883, heartContainer,
                x + offX, y + offY,
                0, 0,
                9, 9,
                9, 9);
        // blit heart
        context.method_25290(class_10799.field_56883, absorptionHeart,
                x + offX, y + offY,
                0, 0,
                9, 9,
                9, 9);

        // Text offset
        offX = 12;
        offY = -14;

        // Draw absorption value + 4px outline
        context.method_51433(textRenderer, text, x + offX + 1, y + offY, class_8012.field_42974, false);
        context.method_51433(textRenderer, text, x + offX - 1, y + offY, class_8012.field_42974, false);
        context.method_51433(textRenderer, text, x + offX, y + offY + 1, class_8012.field_42974, false);
        context.method_51433(textRenderer, text, x + offX, y + offY - 1, class_8012.field_42974, false);
        context.method_51433(textRenderer, text, x + offX, y + offY, class_8012.field_46768, false);
    }

    private void renderAbsorptionBar(class_332 context, float x, float y, class_1657 player) {
        float absorption = player.method_6067();
        float maxHealth = player.method_6063();

        // Calculate bar proportions
        float absorptionProportion = absorption / maxHealth;
        if (absorptionProportion > 1) absorptionProportion = 1F;
        int absorptionWidth = (int) Math.ceil(80 * absorptionProportion);

        // Display full part
        context.method_25290(class_10799.field_56883, absorptionBar,
                (int) x, (int) y - 10,
                0, 0,
                absorptionWidth, 9,
                80, 9);

        // Display empty part
        context.method_25290(class_10799.field_56883, emptyHealthBar,
                (int) x + absorptionWidth, (int) y - 10,
                absorptionWidth, 0,
                80 - absorptionWidth, 9,
                80, 9);

    }

}
