package fr.lanfix.allhudbars.overlay;

import fr.lanfix.allhudbars.AllHudBars;
import net.minecraft.class_10799;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class VehicleBar {

    private static final class_2960 fullHealthBar = class_2960.method_60655(AllHudBars.MOD_ID, "textures/gui/bars/vehicle/full.png");
    private static final class_2960 emptyHealthBar = class_2960.method_60655(AllHudBars.MOD_ID, "textures/gui/bars/vehicle/empty.png");

    public static void render(class_327 textRenderer, class_332 context, class_1309 entity, int x, int y) {
        renderHealthBar(context, x, y, entity);
        renderHealthValue(textRenderer, context, x, y, entity);
    }

    private static void renderHealthValue(class_327 textRenderer, class_332 context, int x, int y, class_1309 entity) {
        double health = Math.ceil(entity.method_6032() * 10) / 10;
        float maxHealth = entity.method_6063();
        String text = health + "/" + maxHealth;
        text = text.replace(".0", "");

        // Offset for text
        int offX = 4;
        int offY = -4;

        // Draw health value + 4px outline
        context.method_51433(textRenderer, text, x + offX + 1, y + offY, 0x000000, false);
        context.method_51433(textRenderer, text, x + offX - 1, y + offY, 0x000000, false);
        context.method_51433(textRenderer, text, x + offX, y + offY + 1, 0x000000, false);
        context.method_51433(textRenderer, text, x + offX, y + offY - 1, 0x000000, false);
        context.method_51433(textRenderer, text, x + offX, y + offY, 0xffffff, false);

    }

    private static void renderHealthBar(class_332 context, int x, int y, class_1309 entity) {
        float health = entity.method_6032();
        float maxHealth = entity.method_6063();

        // Calculate bar proportions
        int textureWidth = 80;
        int healthWidth = (int) Math.min(textureWidth * health / maxHealth, textureWidth);

        // Display full part
        context.method_25290(class_10799.field_56883, fullHealthBar,
                x, y,
                0, 0,
                healthWidth, 9,
                textureWidth, 9);

        // Display empty part
        context.method_25290(class_10799.field_56883, emptyHealthBar,
                x + healthWidth, y,
                healthWidth, 0,
                textureWidth - healthWidth, 9,
                textureWidth, 9);

    }

}
