/*
 * Decompiled with CFR 0.152.
 */
package fr.lanfix.allhudbars.overlay;

import java.util.Random;
import net.minecraft.class_10799;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_638;

public class HealthBar {
    final Random rng = new Random();
    private static final class_2960 fullHealthBar = class_2960.method_60655((String)"allhudbars", (String)"textures/gui/bars/health/full.png");
    private static final class_2960 witherHealthBar = class_2960.method_60655((String)"allhudbars", (String)"textures/gui/bars/health/wither.png");
    private static final class_2960 poisonHealthBar = class_2960.method_60655((String)"allhudbars", (String)"textures/gui/bars/health/poison.png");
    private static final class_2960 frozenHealthBar = class_2960.method_60655((String)"allhudbars", (String)"textures/gui/bars/health/frozen.png");
    private static final class_2960 intermediateHealthBar = class_2960.method_60655((String)"allhudbars", (String)"textures/gui/bars/health/intermediate.png");
    private static final class_2960 emptyHealthBar = class_2960.method_60655((String)"allhudbars", (String)"textures/gui/bars/health/empty.png");
    private static final class_2960 absorptionBar = class_2960.method_60655((String)"allhudbars", (String)"textures/gui/bars/health/absorption.png");
    private static final class_2960 heartContainer = class_2960.method_60655((String)"minecraft", (String)"textures/gui/sprites/hud/heart/container.png");
    private static final class_2960 absorptionHeart = class_2960.method_60655((String)"minecraft", (String)"textures/gui/sprites/hud/heart/absorbing_full.png");
    private class_2960 currentBar = fullHealthBar;
    private double intermediateHealth = 0.0;

    public void render(class_327 textRenderer, class_332 context, class_1657 player, int x, int y, float tickDelta) {
        this.updateBarTextures(player);
        if (player.method_6067() > 0.0f) {
            this.renderAbsorptionBar(context, x, y, player);
            this.renderAbsorptionValue(textRenderer, context, x, y, player);
        }
        this.renderHealthBar(context, tickDelta, x, y, player);
        this.renderHealthValue(textRenderer, context, x, y, player);
    }

    public void updateBarTextures(class_1657 player) {
        this.currentBar = player.method_6059(class_1294.field_5920) ? witherHealthBar : (player.method_6059(class_1294.field_5899) ? poisonHealthBar : (player.method_32314() ? frozenHealthBar : fullHealthBar));
    }

    private void renderHealthValue(class_327 textRenderer, class_332 context, int x, int y, class_1657 player) {
        class_638 world;
        boolean playerHasRegen;
        double health = Math.ceil(player.method_6032() * 10.0f) / 10.0;
        float maxHealth = player.method_6063();
        Object text = health + "/" + (int)player.method_6063();
        text = ((String)text).replace(".0", "");
        boolean isLowHealth = health / (double)maxHealth <= 0.2;
        boolean bl = playerHasRegen = player.method_6059(class_1294.field_5924) || player.method_6059(class_1294.field_5915);
        if (health <= 0.0 && (world = class_310.method_1551().field_1687) != null) {
            boolean isHardcore = world.method_28104().method_152();
            text = class_2561.method_43471((String)("gui.allhudbars.zero_health" + (isHardcore ? ".hardcore" : ""))).getString();
        }
        int offX = 4;
        int offY = -4;
        if (isLowHealth && health > 0.0) {
            offY += this.rng.nextInt(-1, 2);
        }
        int healthColor = -1;
        if (isLowHealth) {
            healthColor = -13108;
        }
        if (playerHasRegen) {
            healthColor = -16711936;
        }
        context.method_51433(textRenderer, (String)text, x + offX + 1, y + offY, -16777216, false);
        context.method_51433(textRenderer, (String)text, x + offX - 1, y + offY, -16777216, false);
        context.method_51433(textRenderer, (String)text, x + offX, y + offY + 1, -16777216, false);
        context.method_51433(textRenderer, (String)text, x + offX, y + offY - 1, -16777216, false);
        context.method_51433(textRenderer, (String)text, x + offX, y + offY, healthColor, false);
    }

    private void renderHealthBar(class_332 context, float tickDelta, float x, float y, class_1657 player) {
        double intermediateProportion;
        double healthProportion;
        float health = player.method_6032();
        float maxHealth = player.method_6063();
        if ((double)health < this.intermediateHealth) {
            healthProportion = health / maxHealth;
            intermediateProportion = (this.intermediateHealth - (double)health) / (double)maxHealth;
        } else {
            healthProportion = this.intermediateHealth / (double)maxHealth;
            intermediateProportion = 0.0;
        }
        if (healthProportion > 1.0) {
            healthProportion = 1.0;
        }
        if (healthProportion + intermediateProportion > 1.0) {
            intermediateProportion = 1.0 - healthProportion;
        }
        int healthWidth = (int)Math.ceil(80.0 * healthProportion);
        int intermediateWidth = (int)Math.ceil(80.0 * intermediateProportion);
        context.method_25290(class_10799.field_56883, this.currentBar, (int)x, (int)y, 0.0f, 0.0f, healthWidth, 9, 80, 9);
        context.method_25290(class_10799.field_56883, intermediateHealthBar, (int)x + healthWidth, (int)y, (float)healthWidth, 0.0f, intermediateWidth, 9, 80, 9);
        context.method_25290(class_10799.field_56883, emptyHealthBar, (int)x + healthWidth + intermediateWidth, (int)y, (float)(healthWidth + intermediateWidth), 0.0f, 80 - healthWidth - intermediateWidth, 9, 80, 9);
        this.intermediateHealth += ((double)health - this.intermediateHealth) * (double)tickDelta * 0.08;
        if (Math.abs((double)health - this.intermediateHealth) <= 0.25) {
            this.intermediateHealth = health;
        }
    }

    private void renderAbsorptionValue(class_327 textRenderer, class_332 context, int x, int y, class_1657 player) {
        double absorption = Math.ceil(player.method_6067() * 10.0f) / 10.0;
        String text = String.valueOf(absorption);
        text = text.replace(".0", "");
        int offX = 1;
        int offY = -15;
        context.method_25290(class_10799.field_56883, heartContainer, x + offX, y + offY, 0.0f, 0.0f, 9, 9, 9, 9);
        context.method_25290(class_10799.field_56883, absorptionHeart, x + offX, y + offY, 0.0f, 0.0f, 9, 9, 9, 9);
        offX = 12;
        offY = -14;
        context.method_51433(textRenderer, text, x + offX + 1, y + offY, -16777216, false);
        context.method_51433(textRenderer, text, x + offX - 1, y + offY, -16777216, false);
        context.method_51433(textRenderer, text, x + offX, y + offY + 1, -16777216, false);
        context.method_51433(textRenderer, text, x + offX, y + offY - 1, -16777216, false);
        context.method_51433(textRenderer, text, x + offX, y + offY, -171, false);
    }

    private void renderAbsorptionBar(class_332 context, float x, float y, class_1657 player) {
        float maxHealth;
        float absorption = player.method_6067();
        float absorptionProportion = absorption / (maxHealth = player.method_6063());
        if (absorptionProportion > 1.0f) {
            absorptionProportion = 1.0f;
        }
        int absorptionWidth = (int)Math.ceil(80.0f * absorptionProportion);
        context.method_25290(class_10799.field_56883, absorptionBar, (int)x, (int)y - 10, 0.0f, 0.0f, absorptionWidth, 9, 80, 9);
        context.method_25290(class_10799.field_56883, emptyHealthBar, (int)x + absorptionWidth, (int)y - 10, (float)absorptionWidth, 0.0f, 80 - absorptionWidth, 9, 80, 9);
    }
}

