package fr.lanfix.allhudbars.mixin;

import fr.lanfix.allhudbars.overlay.*;
import net.minecraft.class_10209;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(class_329.class)
public abstract class HudBarsMixins {

    // TODO Separate texture and text display (like in SHB)

    @Unique
    private static final HealthBar healthBar = new HealthBar();

    @Final
    @Shadow private  class_310 client;

    @Shadow @Nullable protected abstract class_1309 getRiddenEntity();

    @Unique private int lastTicks;

    @Redirect(method = "renderMainHud", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/hud/InGameHud;renderStatusBars(Lnet/minecraft/client/gui/DrawContext;)V"))
    public void renderStatusBars(class_329 instance, class_332 context) {
        // Based on a copy of the original code
        if (this.client.method_1560() instanceof class_1657 player) {

            int left = context.method_51421() / 2 - 91;
            int right = context.method_51421() / 2 + 91;
            int y = context.method_51443() - 39;

            int tickDelta = instance.method_1738() - lastTicks;
            lastTicks = instance.method_1738();

            class_10209.method_64146().method_15396("armor");
            int armorYOffset = player.method_6067() > 0 ? -20 : -10;
            ArmorBar.renderArmorBar(client.field_1772, context, player, y + armorYOffset, left);
            class_10209.method_64146().method_15405("health");
            healthBar.render(client.field_1772, context, player, left, y, tickDelta);
            class_1309 riddenEntity = this.getRiddenEntity();
            if (riddenEntity == null) {
                class_10209.method_64146().method_15405("food");
                FoodBar.renderFoodBar(context, player, y, right);
            }

            class_10209.method_64146().method_15405("air");
            AirBar.renderAirBar(context, player, y - 10, right);

            class_10209.method_64146().method_15407();
        }
    }

    @Redirect(method = "renderMainHud", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/hud/InGameHud;renderMountHealth(Lnet/minecraft/client/gui/DrawContext;)V"))
    public void renderMountHealth(class_329 instance, class_332 context) {
        class_1309 livingEntity = this.getRiddenEntity();
        if (livingEntity != null) {
            int x = context.method_51421() / 2 + 11;
            int y = context.method_51443() - 39;
            VehicleBar.render(client.field_1772, context, livingEntity, x, y);
        }
    }

}
