package fr.lanfix.allhudbars.overlay;

import fr.lanfix.allhudbars.AllHudBars;
import net.minecraft.class_10799;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_8012;

public class ArmorBar {

    private static final class_2960 fullBar = class_2960.method_60655(AllHudBars.MOD_ID, "textures/gui/bars/armor/full.png");
    private static final class_2960 emptyBar = class_2960.method_60655(AllHudBars.MOD_ID, "textures/gui/bars/armor/empty.png");

    private static final class_2960 armorIcon = class_2960.method_60654("textures/gui/sprites/hud/armor_full.png");

    // TODO Change armor texture depending on current equipped armor

    public static void renderArmorBar(class_327 textRenderer, class_332 context, class_1657 player, int y, int left) {
        int armor = player.method_6096();
        if (armor > 0) {
            int textureWidth = 80;
            int armorWidth = Math.min(armor * textureWidth / 20, textureWidth);

            context.method_25290(class_10799.field_56883, emptyBar, left + armorWidth, y, armorWidth, 0, textureWidth - armorWidth, 9, textureWidth, 9);
            context.method_25290(class_10799.field_56883, fullBar, left, y, 0, 0, armorWidth, 9, textureWidth, 9);

            int offX = 1;
            int offY = -5;

            context.method_25290(class_10799.field_56883, armorIcon, left + offX, y + offY, 0, 0, 9, 9, 9, 9);

            // TODO Idea: Instead of this Icon, display the armor set with player.getArmorItems()

            offX += 11;
            offY += 1;

            context.method_51433(textRenderer, String.valueOf(armor), left + offX + 1, y + offY, class_8012.field_42974, false);
            context.method_51433(textRenderer, String.valueOf(armor), left + offX - 1, y + offY, class_8012.field_42974, false);
            context.method_51433(textRenderer, String.valueOf(armor), left + offX, y + offY + 1, class_8012.field_42974, false);
            context.method_51433(textRenderer, String.valueOf(armor), left + offX, y + offY - 1, class_8012.field_42974, false);
            context.method_51433(textRenderer, String.valueOf(armor), left + offX, y + offY, 0xffb7b8c2, false);

        }
    }

}
