/*
 * Decompiled with CFR 0.152.
 */
package ca.blutopia.armorskin;

import ca.blutopia.armorskin.config.ArmorType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class DynamicArmorSkin {
    private Map<ArmorMaterial, Integer> armorPoints = new HashMap<ArmorMaterial, Integer>();
    ArmorMaterial current = ArmorMaterial.NONE;
    private class_310 client;

    public DynamicArmorSkin(class_310 client) {
        this.client = client;
    }

    public <K> K getHighestNumericValue(Map<K, Integer> map) {
        K highVal = null;
        int prevVal = 0;
        for (K key : map.keySet()) {
            if (map.get(key) <= prevVal) continue;
            highVal = key;
            prevVal = map.get(key);
        }
        if (highVal == null && map.size() == 1) {
            return (K)map.keySet().toArray()[0];
        }
        return highVal;
    }

    private void putOrAdd(Map<ArmorMaterial, Integer> map, ArmorMaterial key, int value) {
        if (map.containsKey((Object)key)) {
            map.put(key, map.get((Object)key) + value);
        } else {
            map.put(key, value);
        }
    }

    public void storeArmorValues() {
        this.armorPoints.clear();
        if (this.client.field_1724 == null) {
            return;
        }
        class_746 player = this.client.field_1724;
        class_1799 boots = player.method_6118(class_1304.field_6166);
        class_1799 leggings = player.method_6118(class_1304.field_6172);
        class_1799 chestplate = player.method_6118(class_1304.field_6174);
        class_1799 helmet = player.method_6118(class_1304.field_6169);
        ArmorMaterial bootsMaterial = this.getArmorMaterial(boots);
        ArmorMaterial leggingsMaterial = this.getArmorMaterial(leggings);
        ArmorMaterial chestplateMaterial = this.getArmorMaterial(chestplate);
        ArmorMaterial helmetMaterial = this.getArmorMaterial(helmet);
        this.putOrAdd(this.armorPoints, bootsMaterial, this.getArmorValue(boots));
        this.putOrAdd(this.armorPoints, leggingsMaterial, this.getArmorValue(leggings));
        this.putOrAdd(this.armorPoints, chestplateMaterial, this.getArmorValue(chestplate));
        this.putOrAdd(this.armorPoints, helmetMaterial, this.getArmorValue(helmet));
        this.current = ArmorMaterial.NONE;
    }

    public ArmorType getArmorTypeForIcon(int iconIndex) {
        if (this.current == ArmorMaterial.NONE) {
            this.current = this.getHighestNumericValue(this.armorPoints);
        }
        if (this.current == ArmorMaterial.NONE) {
            return ArmorType.EMPTY;
        }
        if (this.armorPoints.get((Object)this.current) >= 2) {
            this.armorPoints.put(this.current, this.armorPoints.get((Object)this.current) - 2);
            ArmorType type = this.getArmorType(this.current, false, null);
            if (this.armorPoints.get((Object)this.current) == 0) {
                this.armorPoints.remove((Object)this.current);
                this.current = this.getHighestNumericValue(this.armorPoints);
            }
            return type;
        }
        this.armorPoints.remove((Object)this.current);
        ArmorMaterial secondary = this.getHighestNumericValue(this.armorPoints);
        if (secondary == null) {
            secondary = ArmorMaterial.NONE;
        } else {
            this.armorPoints.put(secondary, this.armorPoints.get((Object)secondary) - 1);
            if (this.armorPoints.get((Object)secondary) == 0) {
                this.armorPoints.remove((Object)secondary);
            }
        }
        ArmorType type = this.getArmorType(this.current, true, secondary);
        this.current = this.getHighestNumericValue(this.armorPoints);
        return type;
    }

    private ArmorType getArmorType(ArmorMaterial primary, boolean isMixed, ArmorMaterial secondary) {
        if (!isMixed) {
            return switch (primary.ordinal()) {
                case 1 -> ArmorType.LEATHER;
                case 2 -> ArmorType.CHAIN;
                case 3 -> ArmorType.IRON;
                case 4 -> ArmorType.GOLD;
                case 5 -> ArmorType.DIAMOND;
                case 6 -> ArmorType.NETHERITE;
                default -> ArmorType.EMPTY;
            };
        }
        if (primary == ArmorMaterial.LEATHER && secondary == ArmorMaterial.CHAINMAIL) {
            return ArmorType.LEATHER_CHAIN;
        }
        if (primary == ArmorMaterial.LEATHER && secondary == ArmorMaterial.IRON) {
            return ArmorType.LEATHER_IRON;
        }
        if (primary == ArmorMaterial.LEATHER && secondary == ArmorMaterial.GOLD) {
            return ArmorType.LEATHER_GOLD;
        }
        if (primary == ArmorMaterial.LEATHER && secondary == ArmorMaterial.DIAMOND) {
            return ArmorType.LEATHER_DIAMOND;
        }
        if (primary == ArmorMaterial.LEATHER && secondary == ArmorMaterial.NETHERITE) {
            return ArmorType.LEATHER_NETHERITE;
        }
        if (primary == ArmorMaterial.LEATHER && secondary == ArmorMaterial.NONE) {
            return ArmorType.LEATHER_HALF;
        }
        if (primary == ArmorMaterial.CHAINMAIL && secondary == ArmorMaterial.LEATHER) {
            return ArmorType.CHAIN_LEATHER;
        }
        if (primary == ArmorMaterial.CHAINMAIL && secondary == ArmorMaterial.IRON) {
            return ArmorType.CHAIN_IRON;
        }
        if (primary == ArmorMaterial.CHAINMAIL && secondary == ArmorMaterial.GOLD) {
            return ArmorType.CHAIN_GOLD;
        }
        if (primary == ArmorMaterial.CHAINMAIL && secondary == ArmorMaterial.DIAMOND) {
            return ArmorType.CHAIN_DIAMOND;
        }
        if (primary == ArmorMaterial.CHAINMAIL && secondary == ArmorMaterial.NETHERITE) {
            return ArmorType.CHAIN_NETHERITE;
        }
        if (primary == ArmorMaterial.CHAINMAIL && secondary == ArmorMaterial.NONE) {
            return ArmorType.CHAIN_HALF;
        }
        if (primary == ArmorMaterial.IRON && secondary == ArmorMaterial.LEATHER) {
            return ArmorType.IRON_LEATHER;
        }
        if (primary == ArmorMaterial.IRON && secondary == ArmorMaterial.CHAINMAIL) {
            return ArmorType.IRON_CHAIN;
        }
        if (primary == ArmorMaterial.IRON && secondary == ArmorMaterial.GOLD) {
            return ArmorType.IRON_GOLD;
        }
        if (primary == ArmorMaterial.IRON && secondary == ArmorMaterial.DIAMOND) {
            return ArmorType.IRON_DIAMOND;
        }
        if (primary == ArmorMaterial.IRON && secondary == ArmorMaterial.NETHERITE) {
            return ArmorType.IRON_NETHERITE;
        }
        if (primary == ArmorMaterial.IRON && secondary == ArmorMaterial.NONE) {
            return ArmorType.IRON_HALF;
        }
        if (primary == ArmorMaterial.GOLD && secondary == ArmorMaterial.LEATHER) {
            return ArmorType.GOLD_LEATHER;
        }
        if (primary == ArmorMaterial.GOLD && secondary == ArmorMaterial.CHAINMAIL) {
            return ArmorType.GOLD_CHAIN;
        }
        if (primary == ArmorMaterial.GOLD && secondary == ArmorMaterial.IRON) {
            return ArmorType.GOLD_IRON;
        }
        if (primary == ArmorMaterial.GOLD && secondary == ArmorMaterial.DIAMOND) {
            return ArmorType.GOLD_DIAMOND;
        }
        if (primary == ArmorMaterial.GOLD && secondary == ArmorMaterial.NETHERITE) {
            return ArmorType.GOLD_NETHERITE;
        }
        if (primary == ArmorMaterial.GOLD && secondary == ArmorMaterial.NONE) {
            return ArmorType.GOLD_HALF;
        }
        if (primary == ArmorMaterial.DIAMOND && secondary == ArmorMaterial.LEATHER) {
            return ArmorType.DIAMOND_LEATHER;
        }
        if (primary == ArmorMaterial.DIAMOND && secondary == ArmorMaterial.CHAINMAIL) {
            return ArmorType.DIAMOND_CHAIN;
        }
        if (primary == ArmorMaterial.DIAMOND && secondary == ArmorMaterial.IRON) {
            return ArmorType.DIAMOND_IRON;
        }
        if (primary == ArmorMaterial.DIAMOND && secondary == ArmorMaterial.GOLD) {
            return ArmorType.DIAMOND_GOLD;
        }
        if (primary == ArmorMaterial.DIAMOND && secondary == ArmorMaterial.NETHERITE) {
            return ArmorType.DIAMOND_NETHERITE;
        }
        if (primary == ArmorMaterial.DIAMOND && secondary == ArmorMaterial.NONE) {
            return ArmorType.DIAMOND_HALF;
        }
        if (primary == ArmorMaterial.NETHERITE && secondary == ArmorMaterial.LEATHER) {
            return ArmorType.NETHERITE_LEATHER;
        }
        if (primary == ArmorMaterial.NETHERITE && secondary == ArmorMaterial.CHAINMAIL) {
            return ArmorType.NETHERITE_CHAIN;
        }
        if (primary == ArmorMaterial.NETHERITE && secondary == ArmorMaterial.IRON) {
            return ArmorType.NETHERITE_IRON;
        }
        if (primary == ArmorMaterial.NETHERITE && secondary == ArmorMaterial.GOLD) {
            return ArmorType.NETHERITE_GOLD;
        }
        if (primary == ArmorMaterial.NETHERITE && secondary == ArmorMaterial.DIAMOND) {
            return ArmorType.NETHERITE_DIAMOND;
        }
        if (primary == ArmorMaterial.NETHERITE && secondary == ArmorMaterial.NONE) {
            return ArmorType.NETHERITE_HALF;
        }
        return ArmorType.EMPTY;
    }

    private int getArmorValue(class_1799 armorPiece) {
        if (armorPiece.method_7960()) {
            return 0;
        }
        class_1792 item = armorPiece.method_7909();
        if (item == class_1802.field_8267) {
            return 1;
        }
        if (item == class_1802.field_8577) {
            return 3;
        }
        if (item == class_1802.field_8570) {
            return 2;
        }
        if (item == class_1802.field_8370) {
            return 1;
        }
        if (item == class_1802.field_8862) {
            return 2;
        }
        if (item == class_1802.field_8678) {
            return 5;
        }
        if (item == class_1802.field_8416) {
            return 3;
        }
        if (item == class_1802.field_8753) {
            return 1;
        }
        if (item == class_1802.field_8283) {
            return 2;
        }
        if (item == class_1802.field_8873) {
            return 5;
        }
        if (item == class_1802.field_8218) {
            return 4;
        }
        if (item == class_1802.field_8313) {
            return 1;
        }
        if (item == class_1802.field_8743) {
            return 2;
        }
        if (item == class_1802.field_8523) {
            return 6;
        }
        if (item == class_1802.field_8396) {
            return 5;
        }
        if (item == class_1802.field_8660) {
            return 2;
        }
        if (item == class_1802.field_8805) {
            return 3;
        }
        if (item == class_1802.field_8058) {
            return 8;
        }
        if (item == class_1802.field_8348) {
            return 6;
        }
        if (item == class_1802.field_8285) {
            return 3;
        }
        if (item == class_1802.field_22027) {
            return 3;
        }
        if (item == class_1802.field_22028) {
            return 8;
        }
        if (item == class_1802.field_22029) {
            return 6;
        }
        if (item == class_1802.field_22030) {
            return 3;
        }
        if (item == class_1802.field_8090) {
            return 2;
        }
        return 0;
    }

    private ArmorMaterial getArmorMaterial(class_1799 armorPiece) {
        if (armorPiece.method_7960()) {
            return ArmorMaterial.NONE;
        }
        class_1792 item = armorPiece.method_7909();
        if (item == class_1802.field_8267 || item == class_1802.field_8577 || item == class_1802.field_8570 || item == class_1802.field_8370) {
            return ArmorMaterial.LEATHER;
        }
        if (item == class_1802.field_8283 || item == class_1802.field_8873 || item == class_1802.field_8218 || item == class_1802.field_8313) {
            return ArmorMaterial.CHAINMAIL;
        }
        if (item == class_1802.field_8743 || item == class_1802.field_8523 || item == class_1802.field_8396 || item == class_1802.field_8660) {
            return ArmorMaterial.IRON;
        }
        if (item == class_1802.field_8862 || item == class_1802.field_8678 || item == class_1802.field_8416 || item == class_1802.field_8753) {
            return ArmorMaterial.GOLD;
        }
        if (item == class_1802.field_8805 || item == class_1802.field_8058 || item == class_1802.field_8348 || item == class_1802.field_8285) {
            return ArmorMaterial.DIAMOND;
        }
        if (item == class_1802.field_22027 || item == class_1802.field_22028 || item == class_1802.field_22029 || item == class_1802.field_22030) {
            return ArmorMaterial.NETHERITE;
        }
        return ArmorMaterial.NONE;
    }

    private static enum ArmorMaterial {
        NONE,
        LEATHER,
        CHAINMAIL,
        IRON,
        GOLD,
        DIAMOND,
        NETHERITE;

    }
}

