/*
 * Decompiled with CFR 0.152.
 */
package com.kr1s1s.subtlyd.client.renderer;

import com.google.common.collect.Lists;
import com.kr1s1s.subtlyd.client.model.TentModel;
import com.kr1s1s.subtlyd.client.renderer.state.TentRenderState;
import com.kr1s1s.subtlyd.world.entity.TentEntity;
import java.util.List;
import net.minecraft.class_10017;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3879;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import net.minecraft.class_9848;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class TentRenderer
extends class_897<TentEntity, TentRenderState>
implements class_3883<TentRenderState, TentModel> {
    private final TentModel model;
    private final class_2960 texture;
    protected final List<class_3887<TentRenderState, TentModel>> layers = Lists.newArrayList();

    public TentRenderer(class_5617.class_5618 context, class_5601 modelLayerLocation) {
        super(context);
        this.model = new TentModel(context.method_32167(modelLayerLocation));
        this.texture = modelLayerLocation.comp_2995().method_45134(string -> "textures/entity/" + string + ".png");
        this.field_4673 = 1.8f;
    }

    @NotNull
    public TentModel getModel() {
        return this.model;
    }

    @NotNull
    public TentRenderState createRenderState() {
        return new TentRenderState();
    }

    public void extractRenderState(TentEntity tent, TentRenderState renderState, float partialTicks) {
        super.method_62354((class_1297)tent, (class_10017)renderState, partialTicks);
        renderState.scale = 1.0f;
        renderState.yRot = class_3532.method_16439((float)partialTicks, (float)tent.field_5982, (float)tent.method_36454());
        renderState.xRot = renderState.getXRot(partialTicks);
    }

    @Nullable
    protected class_1921 getRenderType(boolean bl3) {
        class_2960 resourceLocation = this.texture;
        return bl3 ? class_12249.method_76018((class_2960)resourceLocation) : this.model.method_23500(resourceLocation);
    }

    public void submit(TentRenderState renderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState) {
        poseStack.method_22903();
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(270.0f - renderState.yRot));
        float g = renderState.scale;
        poseStack.method_22905(g, g, g);
        poseStack.method_22905(-1.0f, -1.0f, 1.0f);
        poseStack.method_46416(0.0f, -1.501f, 0.0f);
        class_1921 renderType = this.getRenderType(renderState.method_72997());
        if (renderType != null) {
            int i = TentRenderer.getOverlayCoords(renderState, this.getWhiteOverlayProgress());
            int j = -1;
            int k = class_9848.method_61322((int)j, (int)this.getModelTint());
            submitNodeCollector.method_73490((class_3879)this.model, (Object)renderState, poseStack, renderType, renderState.field_61820, i, k, null, renderState.field_61821, null);
        }
        if (this.shouldRenderLayers() && !this.layers.isEmpty()) {
            this.model.method_2819((Object)renderState);
            for (class_3887<TentRenderState, TentModel> renderLayer : this.layers) {
                renderLayer.method_4199(poseStack, submitNodeCollector, renderState.field_61820, (class_10017)renderState, renderState.yRot, renderState.xRot);
            }
        }
        poseStack.method_22909();
        super.method_3936((class_10017)renderState, poseStack, submitNodeCollector, cameraRenderState);
    }

    protected float getWhiteOverlayProgress() {
        return 0.0f;
    }

    protected int getModelTint() {
        return -1;
    }

    public static int getOverlayCoords(TentRenderState renderState, float f) {
        return class_4608.method_23625((int)class_4608.method_23210((float)f), (int)class_4608.method_23212((boolean)renderState.hasRedOverlay));
    }

    protected boolean shouldRenderLayers() {
        return true;
    }
}

