/*
 * Decompiled with CFR 0.152.
 */
package com.kr1s1s.subtlyd.world.entity;

import com.kr1s1s.subtlyd.SubtlyDungeons;
import com.kr1s1s.subtlyd.network.syncher.SynchedEntityDataSD;
import com.kr1s1s.subtlyd.world.entity.ServerPlayerSD;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class TentEntity
extends class_1297 {
    public long lastHit;
    public boolean occupied;
    private final Supplier<class_1792> dropItem;
    private static class_1767 color;

    public TentEntity(class_1299<?> entityType, class_1937 level, Supplier<class_1792> supplier) {
        super(entityType, level);
        this.dropItem = supplier;
        this.occupied = false;
    }

    public static class_2960 getLocation(class_1767 color) {
        return SubtlyDungeons.resourceLocation(color.toString() + "_tent");
    }

    public static class_5321<class_1299<?>> getResourceKey(class_1767 color) {
        return class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)TentEntity.getLocation(color));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(SynchedEntityDataSD.DATA_ID_HURT, (Object)0);
        builder.method_56912(SynchedEntityDataSD.DATA_ID_HURTDIR, (Object)1);
        builder.method_56912(SynchedEntityDataSD.DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public void method_5773() {
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        if (!this.method_31481()) {
            this.pushEntities();
        }
        super.method_5773();
    }

    public void method_5879(float f) {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() * 11.0f);
    }

    public void setHurtDir(int i) {
        this.field_6011.method_12778(SynchedEntityDataSD.DATA_ID_HURTDIR, (Object)i);
    }

    public void setHurtTime(int i) {
        this.field_6011.method_12778(SynchedEntityDataSD.DATA_ID_HURT, (Object)i);
    }

    public void setDamage(float f) {
        this.field_6011.method_12778(SynchedEntityDataSD.DATA_ID_DAMAGE, (Object)Float.valueOf(f));
    }

    public float getDamage() {
        return ((Float)this.field_6011.method_12789(SynchedEntityDataSD.DATA_ID_DAMAGE)).floatValue();
    }

    public int getHurtDir() {
        return (Integer)this.field_6011.method_12789(SynchedEntityDataSD.DATA_ID_HURTDIR);
    }

    public int getHurtTime() {
        return (Integer)this.field_6011.method_12789(SynchedEntityDataSD.DATA_ID_HURT);
    }

    public boolean method_64397(class_3218 serverLevel, class_1282 damageSource, float f) {
        if (this.method_31481()) {
            return false;
        }
        if (!serverLevel.method_64395().method_8355(class_1928.field_19388) && damageSource.method_5529() instanceof class_1308) {
            return false;
        }
        if (damageSource.method_48789(class_8103.field_42242)) {
            this.method_5768(serverLevel);
            return false;
        }
        if (damageSource.method_48789(class_8103.field_42249)) {
            this.broken();
            this.showBreakingParticles();
            this.method_5768(serverLevel);
            return false;
        }
        if (damageSource.method_48789(class_8103.field_42258)) {
            if (this.method_5809()) {
                this.setDamage(0.15f);
            } else {
                this.method_5639(5.0f);
            }
            return false;
        }
        if (damageSource.method_48789(class_8103.field_42259)) {
            this.setDamage(4.0f);
            return false;
        }
        boolean bl = damageSource.method_48789(class_8103.field_46230);
        boolean bl2 = damageSource.method_48789(class_8103.field_46211);
        if (!bl && !bl2) {
            return false;
        }
        class_1297 class_12972 = damageSource.method_5529();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            if (!player.method_31549().field_7476) {
                return false;
            }
        }
        if (damageSource.method_5530()) {
            this.playBrokenSound();
            this.showBreakingParticles();
            this.method_5768(serverLevel);
            return true;
        }
        long l = serverLevel.method_75260();
        if (l - this.lastHit > 5L && !bl2) {
            serverLevel.method_8421((class_1297)this, (byte)32);
            this.method_32875((class_6880)class_5712.field_28736, damageSource.method_5529());
            this.lastHit = l;
            this.showBreakingParticles();
        } else {
            this.broken();
            this.showBreakingParticles();
            this.method_5768(serverLevel);
        }
        return true;
    }

    protected void method_5749(class_11368 valueInput) {
    }

    protected void method_5652(class_11372 valueOutput) {
    }

    protected void pushEntities() {
        List list = this.method_73183().method_66349((class_1297)this, this.method_5829());
        if (!list.isEmpty()) {
            class_3218 serverLevel;
            int i;
            class_1937 class_19372 = this.method_73183();
            if (class_19372 instanceof class_3218 && (i = (serverLevel = (class_3218)class_19372).method_64395().method_8356(class_1928.field_19405)) > 0 && list.size() > i - 1 && this.field_5974.method_43048(4) == 0) {
                int j = 0;
                for (class_1297 entity : list) {
                    if (entity.method_5765()) continue;
                    ++j;
                }
                if (j > i - 1) {
                    this.method_64397(serverLevel, this.method_48923().method_48823(), 6.0f);
                }
            }
            for (class_1297 entity2 : list) {
                this.doPush(entity2);
            }
        }
    }

    protected void doPush(class_1297 entity) {
        entity.method_5697((class_1297)this);
    }

    private void broken() {
        class_1799 itemStack = new class_1799((class_1935)this.dropItem.get());
        itemStack.method_57379(class_9334.field_49631, (Object)this.method_5797());
        class_2248.method_9577((class_1937)this.method_73183(), (class_2338)this.method_24515(), (class_1799)itemStack);
        this.playBrokenSound();
    }

    private void showBreakingParticles() {
        if (this.method_73183() instanceof class_3218) {
            ((class_3218)this.method_73183()).method_65096((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10020.method_9564()), this.method_23317(), this.method_23323(0.6666666666666666), this.method_23321(), 10, (double)(this.method_17681() / 4.0f), (double)(this.method_17682() / 4.0f), (double)(this.method_17681() / 4.0f), 0.05);
        }
    }

    public void method_5711(byte b) {
        if (b == 32) {
            if (this.method_73183().method_8608()) {
                this.method_73183().method_8486(this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14983, this.method_5634(), 0.3f, 1.0f, false);
                this.lastHit = this.method_73183().method_75260();
            }
        } else {
            super.method_5711(b);
        }
    }

    @NotNull
    public class_1269 method_5664(class_1657 player, class_243 vec3, class_1268 interactionHand) {
        if (player.method_73183().method_8608()) {
            return class_1269.field_52422;
        }
        ServerPlayerSD.startSleepInTent(this.method_24515(), this, (class_3222)player).ifLeft(tentSleepingProblem -> {
            if (tentSleepingProblem.getMessage() != null) {
                player.method_7353(tentSleepingProblem.getMessage(), true);
            }
        });
        return class_1269.field_52422;
    }

    public static void allowTentSleep() {
        EntitySleepEvents.ALLOW_BED.register((entity, sleepingPos, state, vanillaResult) -> {
            if (TentEntity.inTentRange((class_1297)entity)) {
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
        EntitySleepEvents.ALLOW_RESETTING_TIME.register(entity -> true);
    }

    public static boolean inTentRange(class_1297 entity) {
        class_238 box = entity.method_5829().method_1014(2.0);
        return !entity.method_73183().method_18467(TentEntity.class, box).isEmpty();
    }

    public static boolean inTent(class_1297 entity) {
        class_238 box = entity.method_5829().method_1011(1.0);
        return !entity.method_73183().method_18467(TentEntity.class, box).isEmpty();
    }

    public static boolean inTent(class_1297 entity, TentEntity tent) {
        class_238 box = entity.method_5829().method_1011(1.0);
        return !entity.method_73183().method_8335((class_1297)tent, box).isEmpty();
    }

    public boolean method_5640(double d) {
        double e = this.method_5829().method_995() * 4.0;
        if (Double.isNaN(e) || e == 0.0) {
            e = 4.0;
        }
        return d < (e *= 64.0) * e;
    }

    private void playBrokenSound() {
        this.method_73183().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14983, this.method_5634(), 1.0f, 1.0f);
    }

    public boolean method_5659(class_1927 explosion) {
        return explosion.method_8347() instanceof class_1308 && !explosion.method_64504().method_64395().method_8355(class_1928.field_19388);
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    public class_1799 method_31480() {
        return new class_1799((class_1935)this.dropItem.get());
    }

    public boolean method_5675() {
        return false;
    }

    @NotNull
    public class_2561 method_5476() {
        return class_2561.method_43473();
    }
}

