/*
 * Decompiled with CFR 0.152.
 */
package dev.benergy10.multiversecommanddestination;

import dev.benergy10.multiversecommanddestination.CommandDestination;
import dev.benergy10.multiversecommanddestination.MultiverseListeners;
import dev.benergy10.multiversecommanddestination.ReloadCommand;
import dev.benergy10.multiversecommanddestination.commandexecutorapi.CommandGroup;
import dev.benergy10.multiversecommanddestination.commandexecutorapi.CommandProvider;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.mvplugins.multiverse.core.MultiverseCoreApi;
import org.mvplugins.multiverse.core.command.MVCommandManager;
import org.mvplugins.multiverse.core.destination.Destination;
import org.mvplugins.multiverse.external.acf.commands.BaseCommand;

public final class MultiverseCommandDestination
extends JavaPlugin {
    private static final String CONFIG_FILENAME = "config.yml";
    private CommandProvider commandProvider;
    private final Map<String, CommandGroup> commandMap = new HashMap<String, CommandGroup>();

    public void onEnable() {
        MultiverseCoreApi coreApi = MultiverseCoreApi.get();
        if (coreApi == null) {
            this.getLogger().warning("Multiverse-Core is not installed on your server.");
            this.getLogger().warning("CommandDestination will not work!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        ((MVCommandManager)coreApi.getServiceLocator().getService(MVCommandManager.class, new Annotation[0])).registerCommand((BaseCommand)new ReloadCommand(this));
        coreApi.getDestinationsProvider().registerDestination((Destination)new CommandDestination(this));
        MultiverseListeners.registerEvents(this);
        this.commandProvider = new CommandProvider();
        this.loadConfig();
    }

    public void loadConfig() {
        YamlConfiguration config;
        ConfigurationSection commandSection;
        this.commandMap.clear();
        File configFile = this.getConfigFile();
        if (!configFile.exists()) {
            this.saveResource(CONFIG_FILENAME, false);
        }
        if ((commandSection = (config = YamlConfiguration.loadConfiguration((File)configFile)).getConfigurationSection("commands")) == null) {
            return;
        }
        for (String cmdName : commandSection.getKeys(false)) {
            List commandList = commandSection.getStringList(cmdName);
            this.commandMap.put(cmdName.toLowerCase(), this.commandProvider.toCommandGroup(commandList));
        }
        this.commandProvider.setUsePapi(config.getBoolean("enable-papi-hook", true));
    }

    public void runCommand(CommandSender sender, Entity entity, String cmdName) {
        CommandGroup commandGroup = this.commandMap.get(cmdName.toLowerCase());
        if (commandGroup == null) {
            sender.sendMessage("No such command destination with key: " + String.valueOf(ChatColor.RED) + cmdName);
            return;
        }
        commandGroup.executeAll((CommandSender)entity);
    }

    @NotNull
    public File getConfigFile() {
        return new File(this.getDataFolder(), CONFIG_FILENAME);
    }

    @NotNull
    public CommandProvider getCommandProvider() {
        return this.commandProvider;
    }

    @NotNull
    public @Unmodifiable Map<String, CommandGroup> getCommandMap() {
        return this.commandMap;
    }
}

