/*
 * Decompiled with CFR 0.152.
 */
package dev.benergy10.multiversecommanddestination;

import dev.benergy10.multiversecommanddestination.CommandDestinationInstance;
import dev.benergy10.multiversecommanddestination.MultiverseCommandDestination;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.core.event.MVConfigReloadEvent;
import org.mvplugins.multiverse.core.event.MVDumpsDebugInfoEvent;
import org.mvplugins.multiverse.core.event.MVTeleportDestinationEvent;
import org.mvplugins.multiverse.portals.event.MVPortalEvent;

public class MultiverseListeners {
    public static void registerEvents(MultiverseCommandDestination plugin) {
        MultiverseListeners.tryRegister("org.mvplugins.multiverse.core.event.MVTeleportDestinationEvent", new TeleportListener(plugin));
        MultiverseListeners.tryRegister("org.mvplugins.multiverse.portals.event.MVPortalEvent", new PortalListener(plugin));
        MultiverseListeners.tryRegister("org.mvplugins.multiverse.core.event.MVConfigReloadEvent", new ReloadListener(plugin));
        MultiverseListeners.tryRegister("org.mvplugins.multiverse.core.event.MVDumpsDebugInfoEvent", new VersionListener(plugin));
    }

    private static void tryRegister(String eventClass, AbstractListener listener) {
        try {
            Class.forName(eventClass);
            Bukkit.getPluginManager().registerEvents((Listener)listener, (Plugin)listener.plugin);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static class TeleportListener
    extends AbstractListener {
        private TeleportListener(MultiverseCommandDestination plugin) {
            super(plugin);
        }

        @EventHandler
        public void onTeleport(MVTeleportDestinationEvent event) {
            DestinationInstance dest = event.getDestination();
            if (!(dest instanceof CommandDestinationInstance)) {
                return;
            }
            CommandDestinationInstance cmdDest = (CommandDestinationInstance)dest;
            this.plugin.runCommand(event.getTeleporter(), event.getTeleportee(), cmdDest.getCommandKey());
            event.setCancelled(true);
        }
    }

    private static abstract class AbstractListener
    implements Listener {
        protected final MultiverseCommandDestination plugin;

        private AbstractListener(MultiverseCommandDestination plugin) {
            this.plugin = plugin;
        }
    }

    private static class PortalListener
    extends AbstractListener {
        private PortalListener(MultiverseCommandDestination plugin) {
            super(plugin);
        }

        @EventHandler
        public void onPortal(MVPortalEvent event) {
            DestinationInstance dest = event.getDestination();
            if (!(dest instanceof CommandDestinationInstance)) {
                return;
            }
            CommandDestinationInstance cmdDest = (CommandDestinationInstance)dest;
            this.plugin.runCommand((CommandSender)event.getTeleportee(), (Entity)event.getTeleportee(), cmdDest.getCommandKey());
            event.setCancelled(true);
        }
    }

    private static class ReloadListener
    extends AbstractListener {
        private ReloadListener(MultiverseCommandDestination plugin) {
            super(plugin);
        }

        @EventHandler
        public void onReload(MVConfigReloadEvent event) {
            this.plugin.loadConfig();
            event.addConfig("Multiverse-CommandDestination - config.yml");
        }
    }

    private static class VersionListener
    extends AbstractListener {
        private VersionListener(MultiverseCommandDestination plugin) {
            super(plugin);
        }

        @EventHandler
        public void onVersion(MVDumpsDebugInfoEvent event) {
            event.putDetailedDebugInfo("Multiverse-CommandDestination/config.yml", this.plugin.getConfigFile());
            event.appendDebugInfo("[Multiverse-CommandDestination] Multiverse-CommandDestination version: " + this.plugin.getDescription().getVersion() + "\n[Multiverse-CommandDestination] Loaded commands: " + String.valueOf(this.plugin.getCommandMap()) + "\n[Multiverse-CommandDestination] Papi installed: " + this.plugin.getCommandProvider().isPapiInstalled() + "\n[Multiverse-CommandDestination] Allow papi hook: " + this.plugin.getCommandProvider().isUsePapi() + "\n");
        }
    }
}

