/*
 * Decompiled with CFR 0.152.
 */
package dev.tonimatas.packetfixer.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;

public class Config {
    private static boolean allSizesUnlimited = true;
    private static long nbtMaxSize = 0x200000L;
    private static int packetSize = 0x100000;
    private static int decoderSize = 0x800000;
    private static int varInt21 = 3;
    private static int varInt = 5;
    private static int varLong = 10;
    private static int stringSize = Short.MAX_VALUE;
    private static int chunkPacketData = 0x200000;
    private static int timeout = 120;
    private static int readTimeout = 120;
    private static int loginTimeout = 120;
    private static int keepAliveTimeout = 120;
    private static boolean forceUnlimitedNbtEnabled = false;

    public static void runProperties() {
        try {
            File configFolder = new File("config");
            if (!configFolder.exists()) {
                configFolder.mkdirs();
            }
            File propertiesFile = new File(configFolder, "packetfixer.properties");
            Properties properties = new Properties();
            if (!propertiesFile.exists()) {
                propertiesFile.createNewFile();
            }
            properties.load(Files.newInputStream(propertiesFile.toPath(), new OpenOption[0]));
            allSizesUnlimited = Boolean.parseBoolean(Config.checkVariable(properties, "allSizesUnlimited", String.valueOf(allSizesUnlimited)));
            nbtMaxSize = Long.parseLong(Config.checkVariable(properties, "nbtMaxSize", String.valueOf(nbtMaxSize)));
            packetSize = Integer.parseInt(Config.checkVariable(properties, "packetSize", Integer.toString(packetSize)));
            decoderSize = Integer.parseInt(Config.checkVariable(properties, "decoderSize", Integer.toString(decoderSize)));
            varInt21 = Integer.parseInt(Config.checkVariable(properties, "varInt21", Integer.toString(varInt21)));
            varInt = Integer.parseInt(Config.checkVariable(properties, "varInt", Integer.toString(varInt)));
            varLong = Integer.parseInt(Config.checkVariable(properties, "varLong", Integer.toString(varLong)));
            stringSize = Integer.parseInt(Config.checkVariable(properties, "stringSize", Integer.toString(stringSize)));
            chunkPacketData = Integer.parseInt(Config.checkVariable(properties, "chunkPacketData", Integer.toString(chunkPacketData)));
            timeout = Integer.parseInt(Config.checkVariable(properties, "timeout", Integer.toString(timeout)));
            readTimeout = Integer.parseInt(Config.checkVariable(properties, "readTimeout", Integer.toString(readTimeout)));
            loginTimeout = Integer.parseInt(Config.checkVariable(properties, "loginTimeout", Integer.toString(loginTimeout)));
            keepAliveTimeout = Integer.parseInt(Config.checkVariable(properties, "keepAliveTimeout", Integer.toString(keepAliveTimeout)));
            forceUnlimitedNbtEnabled = Boolean.parseBoolean(Config.checkVariable(properties, "forceUnlimitedNbtEnabled", Boolean.toString(forceUnlimitedNbtEnabled)));
            Config.save(properties, propertiesFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static long getNbtMaxSize() {
        return allSizesUnlimited ? Long.MAX_VALUE : nbtMaxSize;
    }

    public static int getPacketSize() {
        return allSizesUnlimited ? Integer.MAX_VALUE : packetSize;
    }

    public static int getDecoderSize() {
        return allSizesUnlimited ? Integer.MAX_VALUE : decoderSize;
    }

    public static int getVarInt21Size() {
        return allSizesUnlimited ? Integer.MAX_VALUE : varInt21;
    }

    public static int getVarIntSize() {
        return allSizesUnlimited ? 0x3FFFFFFE : varInt;
    }

    public static int getVarLong() {
        return allSizesUnlimited ? 0x3FFFFFFE : varLong;
    }

    public static int getStringSize() {
        return allSizesUnlimited ? 327670000 : stringSize;
    }

    public static int getChunkPacketData() {
        return allSizesUnlimited ? Integer.MAX_VALUE : chunkPacketData;
    }

    public static int getTimeout() {
        return timeout;
    }

    public static int getReadTimeout() {
        return readTimeout;
    }

    public static int getLoginTimeout() {
        return loginTimeout;
    }

    public static int getKeepAliveTimeout() {
        return keepAliveTimeout;
    }

    public static boolean isForceUnlimitedNbtEnabled() {
        return forceUnlimitedNbtEnabled;
    }

    private static String checkVariable(Properties properties, String variable, String defaultValue) {
        if (properties.getProperty(variable) == null) {
            properties.setProperty(variable, defaultValue);
        }
        return properties.getProperty(variable);
    }

    private static void save(Properties properties, File propertiesFile) throws IOException {
        properties.store(Files.newOutputStream(propertiesFile.toPath(), new OpenOption[0]), "Packet Fixer config file.\nDefault values (minecraft default): nbtMaxSize 2097152, packetSize 1048576, decoderSize 8388608 and varInt21Size 3.\nMax values are 2147483647 for packetSize/decoderSize/varInt21 and 9223372036854775807 for nbtMaxSize.");
    }
}

