/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.signedit.helper;

import dev.terminalmc.signedit.helper.LinePoint;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldHelper
extends TextFieldHelper {
    private final Supplier<String> getMessageFn = () -> {
        if (cachedText == null) {
            cachedText = FieldHelper.unwrap((String[])getMessage.get());
        }
        return cachedText;
    };
    private final Supplier<Integer> getMaxWidthFn;
    private final int lineCount;
    @Nullable
    public static String cachedText = null;

    public FieldHelper(Supplier<String[]> getMessage, Consumer<String[]> setMessage, Supplier<String> getClipboard, Consumer<String> setClipboard, Supplier<Integer> getMaxWidth, Integer lineCount) {
        super(() -> {
            if (cachedText == null) {
                cachedText = FieldHelper.unwrap((String[])getMessage.get());
            }
            return cachedText;
        }, str -> {
            cachedText = str;
            setMessage.accept(FieldHelper.wrap(str, (Integer)getMaxWidth.get(), lineCount));
        }, getClipboard, setClipboard, str -> FieldHelper.fits(str, (Integer)getMaxWidth.get(), lineCount));
        this.getMaxWidthFn = getMaxWidth;
        this.lineCount = lineCount;
        this.setCursorToEnd();
    }

    public boolean linebreakBefore(int line) {
        String text = this.getMessageFn.get();
        int maxWidth = this.getMaxWidthFn.get();
        if (line <= 0 || line >= this.lineCount) {
            return false;
        }
        String[] lines = FieldHelper.wrap(text, maxWidth, this.lineCount);
        for (int i = 0; i <= text.length(); ++i) {
            if (FieldHelper.linePoint(text, lines, i).line() != line) continue;
            return i > 0 && String.valueOf(text.charAt(i - 1)).equals("\n");
        }
        return false;
    }

    public void cursorToLine(int line, boolean hasShiftDown) {
        String text = this.getMessageFn.get();
        int maxWidth = this.getMaxWidthFn.get();
        String[] lines = FieldHelper.wrap(text, maxWidth, this.lineCount);
        LinePoint primaryLp = new LinePoint(line, lines[line].length());
        for (int i = 0; i <= text.length(); ++i) {
            if (!FieldHelper.linePoint(text, lines, i).equals(primaryLp)) continue;
            this.setCursorPos(i, hasShiftDown);
        }
    }

    public LinePoint linePoint(int targetIdx) {
        String text = this.getMessageFn.get();
        int maxWidth = this.getMaxWidthFn.get();
        return FieldHelper.linePoint(text, FieldHelper.wrap(text, maxWidth, this.lineCount), targetIdx);
    }

    private static LinePoint linePoint(String text, String[] lines, int targetIdx) {
        int idx = 0;
        for (int line = 0; line < lines.length; ++line) {
            for (int point = 0; point <= lines[line].length(); ++point) {
                if (point == lines[line].length() && text.length() >= idx && point > 0 && idx > 0 && String.valueOf(text.charAt(idx - 1)).equals("\n") && idx++ == targetIdx) {
                    return new LinePoint(line + 1, 0);
                }
                if (line > 0 && point == 0 && !String.valueOf(text.charAt(idx - 1)).equals("\n") && point++ > 0 && idx++ == targetIdx) {
                    return new LinePoint(line, point + 1);
                }
                if (idx++ != targetIdx) continue;
                return new LinePoint(line, point);
            }
        }
        return new LinePoint(0, 0);
    }

    public static String unwrap(String[] lines) {
        StringBuilder builder = new StringBuilder();
        for (String line : lines) {
            builder.append(line);
            builder.append("\n");
        }
        String str = builder.toString();
        while (str.endsWith("\n")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static boolean fits(String input, int maxWidth, int lineCount) {
        ArrayList<String> lines = new ArrayList<String>();
        for (String rawLine : input.split("\n", Integer.MAX_VALUE)) {
            FieldHelper.addWrapped(rawLine, maxWidth, lines);
        }
        return lines.size() <= lineCount;
    }

    public static String[] wrap(String input, int maxWidth, int lineCount) {
        String[] rawLines;
        ArrayList<String> lines = new ArrayList<String>();
        for (String rawLine : rawLines = input.split("\n", Integer.MAX_VALUE)) {
            FieldHelper.addWrapped(rawLine, maxWidth, lines);
        }
        while (lines.size() > lineCount) {
            lines.removeLast();
        }
        while (lines.size() < lineCount) {
            lines.add("");
        }
        return lines.toArray(new String[0]);
    }

    private static void addWrapped(String line, int maxWidth, List<String> lines) {
        if (line.isEmpty()) {
            lines.add(line);
            return;
        }
        int start = 0;
        while (start < line.length()) {
            int end = FieldHelper.findBreakpoint(line, start, maxWidth);
            lines.add(line.substring(start, end));
            start = end;
        }
    }

    private static int findBreakpoint(String str, int start, int maxWidth) {
        int end;
        int lastGoodBreak = -1;
        for (end = start; end < str.length() && Minecraft.getInstance().font.width(str.substring(start, end + 1)) <= maxWidth; ++end) {
            char c = str.charAt(end);
            if (!Character.isWhitespace(c) && c != '-') continue;
            lastGoodBreak = end + 1;
        }
        if (end == str.length()) {
            return end;
        }
        if (lastGoodBreak != -1 && lastGoodBreak > start) {
            return lastGoodBreak;
        }
        if (end == start) {
            return start + 1;
        }
        return end;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean keyPressed(@NotNull KeyEvent event) {
        if (cachedText == null) {
            return false;
        }
        if (event.isSelectAll()) {
            this.selectAll();
            return true;
        }
        if (event.isCopy()) {
            this.copy();
            return true;
        }
        if (event.isPaste()) {
            this.paste();
            return true;
        }
        if (event.isCut()) {
            this.cut();
            return true;
        }
        TextFieldHelper.CursorStep step = event.hasControlDown() ? TextFieldHelper.CursorStep.WORD : TextFieldHelper.CursorStep.CHARACTER;
        switch (event.key()) {
            case 257: 
            case 335: {
                this.insertText("\n");
                return true;
            }
            case 259: {
                this.removeFromCursor(-1, step);
                return true;
            }
            case 261: {
                this.removeFromCursor(1, step);
                return true;
            }
            case 263: {
                this.moveBy(-1, event.hasShiftDown(), step);
                return true;
            }
            case 262: {
                this.moveBy(1, event.hasShiftDown(), step);
                return true;
            }
            case 268: {
                int start;
                for (int i = start = this.getCursorPos(); i >= 0; --i) {
                    if (i <= 0 || i >= start || !String.valueOf(cachedText.charAt(i - 1)).equals("\n")) continue;
                    this.setCursorPos(i, event.hasShiftDown());
                    return true;
                }
                this.setCursorToStart(event.hasShiftDown());
                return true;
            }
            case 269: {
                int start;
                int max = cachedText.length();
                for (int i = start = this.getCursorPos(); i <= max; ++i) {
                    if (i != max && (i <= start || !String.valueOf(cachedText.charAt(i)).equals("\n"))) continue;
                    this.setCursorPos(i, event.hasShiftDown());
                    return true;
                }
                this.setCursorToEnd(event.hasShiftDown());
                return true;
            }
            default: {
                return false;
            }
        }
    }

    public boolean charTyped(@NotNull CharacterEvent event) {
        return super.charTyped(event);
    }

    private static String escaped(String[] arr) {
        StringBuilder builder = new StringBuilder();
        for (String str : arr) {
            builder.append("'").append(FieldHelper.escaped(str)).append("', ");
        }
        String out = builder.length() > 2 ? builder.substring(0, builder.length() - 2) : builder.toString();
        return "[" + out + "]";
    }

    private static String escaped(String str) {
        return str.replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t").replace("\f", "\\f").replace("\b", "\\b");
    }
}

