/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.signedit.helper;

import dev.terminalmc.signedit.helper.FieldHelper;
import dev.terminalmc.signedit.helper.LinePoint;
import java.util.ArrayList;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;

public class ScreenHelper {
    public static boolean keyPressed(String[] lines, FieldHelper field, int line, KeyEvent event) {
        return switch (event.key()) {
            case 265 -> {
                field.cursorToLine(Math.floorMod(line - 1, lines.length), event.hasShiftDown());
                yield true;
            }
            case 264 -> {
                field.cursorToLine(Math.floorMod(line + 1, lines.length), event.hasShiftDown());
                yield true;
            }
            default -> false;
        };
    }

    public static void renderLinebreaks(GuiGraphics graphics, Font font, FieldHelper helper, SignBlockEntity sign, SignText text, String[] messages) {
        int color = text.hasGlowingText() ? text.getColor().getTextColor() : SignRenderer.getDarkColor((SignText)text);
        int lineHeight = sign.getTextLineHeight();
        int centerY = messages.length * sign.getTextLineHeight() / 2;
        for (int i = 1; i < messages.length; ++i) {
            String str = messages[i];
            if (str == null || !helper.linebreakBefore(i)) continue;
            graphics.drawString(font, "\u21a9", sign.getMaxTextLineWidth() / 2, (i - 1) * lineHeight - centerY, color, false);
        }
    }

    public static void renderHighlight(GuiGraphics graphics, Font font, FieldHelper helper, SignBlockEntity sign, String[] messages) {
        int i;
        int idx1 = Math.min(helper.getCursorPos(), helper.getSelectionPos());
        int idx2 = Math.max(helper.getCursorPos(), helper.getSelectionPos());
        LinePoint linePoint1 = helper.linePoint(idx1);
        LinePoint linePoint2 = helper.linePoint(idx2);
        ArrayList<LinePoint> linePoints = new ArrayList<LinePoint>();
        linePoints.add(linePoint1);
        for (i = linePoint1.line(); i < linePoint2.line(); ++i) {
            linePoints.add(new LinePoint(i, messages[i].length()));
            linePoints.add(new LinePoint(i + 1, 0));
        }
        linePoints.add(linePoint2);
        for (i = 0; i < linePoints.size() - 1; i += 2) {
            LinePoint lp1 = (LinePoint)linePoints.get(i);
            LinePoint lp2 = (LinePoint)linePoints.get(i + 1);
            int l = lp1.line();
            String line = messages[l];
            int startIdx = lp1.point();
            int endIdx = lp2.point();
            int middle = 4 * sign.getTextLineHeight() / 2;
            int m = l * sign.getTextLineHeight() - middle;
            int s = font.width(line.substring(0, startIdx)) - font.width(line) / 2;
            int t = font.width(line.substring(0, endIdx)) - font.width(line) / 2;
            int u = Math.min(s, t);
            int v = Math.max(s, t);
            graphics.fill(RenderPipelines.GUI_TEXT_HIGHLIGHT, u, m, v, m + sign.getTextLineHeight(), -16776961);
        }
    }
}

