/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.signedit.mixin.copy;

import dev.terminalmc.signedit.SignEdit;
import dev.terminalmc.signedit.util.Localization;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SignBlock.class})
public class SignBlockMixin {
    @Inject(method={"useItemOn"}, at={@At(value="HEAD")})
    public void onSignUse(ItemStack itemStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult, CallbackInfoReturnable<InteractionResult> cir) {
        SignBlockEntity sign;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof SignBlockEntity && (sign = (SignBlockEntity)blockEntity).isWaxed() && itemStack.isEmpty()) {
            Component[] textLines = sign.getFrontText().getMessages(false);
            String[] lines = new String[textLines.length];
            for (int i = 0; i < textLines.length; ++i) {
                lines[i] = textLines[i].getString();
            }
            SignEdit.copiedLines = lines;
            player.displayClientMessage((Component)Localization.localized("message", "copied", new Object[0]), true);
        }
    }
}

