/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.signedit.mixin.edit;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.terminalmc.signedit.SignEdit;
import dev.terminalmc.signedit.helper.FieldHelper;
import dev.terminalmc.signedit.helper.ScreenHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractSignEditScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Debug(export=true)
@Mixin(value={AbstractSignEditScreen.class})
public abstract class AbstractSignEditScreenMixin
extends Screen {
    @Shadow
    private SignText text;
    @Shadow
    @Final
    private String[] messages;
    @Shadow
    @Nullable
    private TextFieldHelper signField;
    @Shadow
    private int line;
    @Shadow
    @Final
    protected SignBlockEntity sign;
    @Shadow
    @Final
    private boolean isFrontText;

    protected AbstractSignEditScreenMixin(Component title) {
        super(title);
    }

    @Shadow
    public abstract void onClose();

    @WrapOperation(method={"init"}, at={@At(value="FIELD", target="Lnet/minecraft/client/gui/screens/inventory/AbstractSignEditScreen;signField:Lnet/minecraft/client/gui/font/TextFieldHelper;", opcode=181)})
    private void wrapSetHelper(AbstractSignEditScreen instance, TextFieldHelper value, Operation<Void> original) {
        if (!SignEdit.enhancedEditing) {
            original.call(new Object[]{instance, value});
            return;
        }
        FieldHelper.cachedText = null;
        Object[] objectArray = new Object[2];
        objectArray[0] = instance;
        objectArray[1] = new FieldHelper(() -> this.messages, this::signEdit$setMessages, TextFieldHelper.createClipboardGetter((Minecraft)Minecraft.getInstance()), TextFieldHelper.createClipboardSetter((Minecraft)Minecraft.getInstance()), () -> ((SignBlockEntity)this.sign).getMaxTextLineWidth(), this.messages.length);
        original.call(objectArray);
    }

    @Unique
    private void signEdit$setMessages(String[] newMessages) {
        for (int i = 0; i < newMessages.length; ++i) {
            this.messages[i] = newMessages[i];
            this.text.setMessage(i, (Component)Component.literal((String)newMessages[i]));
        }
        this.sign.setText(this.text, this.isFrontText);
    }

    @WrapMethod(method={"keyPressed"})
    private boolean wrapKeyPressed(KeyEvent event, Operation<Boolean> original) {
        if (!SignEdit.enhancedEditing) {
            return (Boolean)original.call(new Object[]{event});
        }
        if (this.signField != null && this.messages.length > 0 && (ScreenHelper.keyPressed(this.messages, (FieldHelper)this.signField, this.line, event) || this.signField.keyPressed(event))) {
            return true;
        }
        if (event.key() != 32 && event.key() != 258) {
            return super.keyPressed(event);
        }
        return false;
    }

    @Inject(method={"renderSignText"}, at={@At(value="HEAD")})
    private void beforeRenderSignText(GuiGraphics graphics, CallbackInfo ci) {
        if (!SignEdit.enhancedEditing) {
            return;
        }
        assert (this.signField != null);
        this.line = ((FieldHelper)this.signField).linePoint(this.signField.getCursorPos()).line();
    }

    @WrapOperation(method={"renderSignText"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/font/TextFieldHelper;getCursorPos()I")})
    private int wrapGetCursorPos(TextFieldHelper instance, Operation<Integer> original) {
        if (!SignEdit.enhancedEditing) {
            return (Integer)original.call(new Object[]{instance});
        }
        assert (this.signField != null);
        return ((FieldHelper)this.signField).linePoint((Integer)original.call(new Object[]{instance})).point();
    }

    @WrapOperation(method={"renderSignText"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/font/TextFieldHelper;getSelectionPos()I")})
    private int wrapGetSelectionPos(TextFieldHelper instance, Operation<Integer> original) {
        if (!SignEdit.enhancedEditing) {
            return (Integer)original.call(new Object[]{instance});
        }
        assert (this.signField != null);
        return ((FieldHelper)this.signField).linePoint(this.signField.getCursorPos()).point();
    }

    @Inject(method={"renderSignText"}, at={@At(value="RETURN")})
    private void afterRenderSignText(GuiGraphics graphics, CallbackInfo ci) {
        if (!SignEdit.enhancedEditing) {
            return;
        }
        assert (this.signField != null);
        FieldHelper helper = (FieldHelper)this.signField;
        ScreenHelper.renderLinebreaks(graphics, this.font, helper, this.sign, this.text, this.messages);
        ScreenHelper.renderHighlight(graphics, this.font, helper, this.sign, this.messages);
    }
}

