/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.signedit.mixin.gui;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.terminalmc.signedit.SignEdit;
import dev.terminalmc.signedit.config.Config;
import dev.terminalmc.signedit.util.Localization;
import java.util.Arrays;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractSignEditScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractSignEditScreen.class})
public abstract class AbstractSignEditScreenMixin
extends Screen {
    @Shadow
    @Final
    private String[] messages;

    protected AbstractSignEditScreenMixin(Component title) {
        super(title);
    }

    @Shadow
    public abstract void onClose();

    @Inject(method={"<init>(Lnet/minecraft/world/level/block/entity/SignBlockEntity;ZZLnet/minecraft/network/chat/Component;)V"}, at={@At(value="RETURN")})
    private void afterConstructor(SignBlockEntity sign, boolean isFrontText, boolean isFiltered, Component title, CallbackInfo ci) {
        SignEdit.enhancedEditing = Config.options().useEnhancedEditor;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @WrapOperation(method={"init"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractSignEditScreen;addRenderableWidget(Lnet/minecraft/client/gui/components/events/GuiEventListener;)Lnet/minecraft/client/gui/components/events/GuiEventListener;")})
    private GuiEventListener wrapAddDoneButton(AbstractSignEditScreen instance, GuiEventListener doneButton, Operation<GuiEventListener> original) {
        this.clearWidgets();
        int rowCount = 0;
        if (Config.options().showActionButtons) {
            ++rowCount;
        }
        if (Config.options().useEnhancedEditor) {
            ++rowCount;
        }
        int totalWidth = 200;
        int buttonHeight = 20;
        int spaceX = 10;
        int spaceY = 2;
        int rowHeight = buttonHeight + spaceY;
        int baseX = this.width / 2 - 100;
        int movingY = this.height / 4 + 144 - rowHeight * rowCount;
        if (Config.options().showActionButtons) {
            int movingX = baseX;
            int buttonWidth = (totalWidth - spaceX * 2) / 3;
            Button copyButton = Button.builder((Component)Localization.localized("button", "copy", new Object[0]), button -> this.signEdit$copyText()).bounds(movingX, movingY, buttonWidth, buttonHeight).build();
            original.call(new Object[]{instance, copyButton});
            Button insertButton = Button.builder((Component)Localization.localized("button", "insert", new Object[0]), button -> this.signEdit$insertText()).bounds(movingX += buttonWidth + spaceX, movingY, buttonWidth, buttonHeight).build();
            original.call(new Object[]{instance, insertButton});
            movingX = baseX + totalWidth - buttonWidth;
            Button eraseButton = Button.builder((Component)Localization.localized("button", "erase", new Object[0]), button -> this.signEdit$eraseText()).bounds(movingX, movingY, buttonWidth, buttonHeight).build();
            original.call(new Object[]{instance, eraseButton});
            movingY += rowHeight;
        }
        if (Config.options().useEnhancedEditor) {
            @NotNull CycleButton statusButton = CycleButton.onOffBuilder((boolean)SignEdit.enhancedEditing).create(baseX, movingY, totalWidth, buttonHeight, (Component)Localization.localized("button", "enhancedEditing", new Object[0]), (button, status) -> {
                if (SignEdit.enhancedEditing != status) {
                    SignEdit.enhancedEditing = status;
                    this.init();
                }
            });
            original.call(new Object[]{instance, statusButton});
        }
        return (GuiEventListener)original.call(new Object[]{instance, doneButton});
    }

    @Unique
    private void signEdit$copyText() {
        if (this.signEdit$hasText()) {
            SignEdit.copiedLines = new String[this.messages.length];
            System.arraycopy(this.messages, 0, SignEdit.copiedLines, 0, this.messages.length);
            this.signEdit$finish();
        }
    }

    @Unique
    private void signEdit$insertText() {
        if (SignEdit.copiedLines != null) {
            System.arraycopy(SignEdit.copiedLines, 0, this.messages, 0, Math.min(SignEdit.copiedLines.length, this.messages.length));
            this.signEdit$finish();
        }
    }

    @Unique
    private void signEdit$eraseText() {
        if (this.signEdit$hasText()) {
            Arrays.fill(this.messages, "");
            this.signEdit$finish();
        }
    }

    @Unique
    private boolean signEdit$hasText() {
        for (String s : this.messages) {
            if (s.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Unique
    private void signEdit$finish() {
        if (Config.options().actionButtonsCloseUi) {
            this.onClose();
        } else {
            this.init();
        }
    }
}

