/*
 * Decompiled with CFR 0.152.
 */
package net.uku3lig.chathighlighter.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import lombok.Generated;
import net.minecraft.class_310;

public class ChatHighlighterConfig
implements Serializable {
    private List<String> text;
    private int color = 0x7FFFFF00;
    private boolean usePattern = false;
    private boolean playSound = true;
    private String sound = "block.note_block.bell";

    public Optional<Pattern> getPattern() {
        if (this.text.isEmpty()) {
            return Optional.empty();
        }
        String first = this.text.getFirst();
        if (first.isBlank()) {
            return Optional.empty();
        }
        try {
            return Optional.of(Pattern.compile(first));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public String getJoinedText() {
        return String.join((CharSequence)", ", this.text);
    }

    public void setJoinedText(String text) {
        this.text = new ArrayList<String>(Arrays.asList(text.split(", *")));
    }

    private ChatHighlighterConfig(String text) {
        this.text = new ArrayList<String>();
        this.text.add(text);
    }

    public ChatHighlighterConfig() {
        this(class_310.method_1551().field_1724 != null ? class_310.method_1551().field_1724.method_5820() : "uku3lig");
    }

    @Generated
    public ChatHighlighterConfig(List<String> text, int color, boolean usePattern, boolean playSound, String sound) {
        this.text = text;
        this.color = color;
        this.usePattern = usePattern;
        this.playSound = playSound;
        this.sound = sound;
    }

    @Generated
    public List<String> getText() {
        return this.text;
    }

    @Generated
    public int getColor() {
        return this.color;
    }

    @Generated
    public boolean isUsePattern() {
        return this.usePattern;
    }

    @Generated
    public boolean isPlaySound() {
        return this.playSound;
    }

    @Generated
    public String getSound() {
        return this.sound;
    }

    @Generated
    public void setText(List<String> text) {
        this.text = text;
    }

    @Generated
    public void setColor(int color) {
        this.color = color;
    }

    @Generated
    public void setUsePattern(boolean usePattern) {
        this.usePattern = usePattern;
    }

    @Generated
    public void setPlaySound(boolean playSound) {
        this.playSound = playSound;
    }

    @Generated
    public void setSound(String sound) {
        this.sound = sound;
    }
}

