/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.hedgemod.init;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.mcreator.hedgemod.HedgemodMod;
import net.mcreator.hedgemod.init.HedgemodModBlocks;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class HedgemodModVillagerProfessions {
    private static final Map<String, ProfessionPoiType> POI_TYPES = new HashMap<String, ProfessionPoiType>();
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PROFESSIONS, (String)"hedgemod");
    public static final RegistryObject<VillagerProfession> FOOD_VENDOR = HedgemodModVillagerProfessions.registerProfession("food_vendor", () -> (Block)HedgemodModBlocks.HOT_DOG_STAND.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.yes")));

    private static RegistryObject<VillagerProfession> registerProfession(String name, Supplier<Block> block, Supplier<SoundEvent> soundEvent) {
        POI_TYPES.put(name, new ProfessionPoiType(block, null));
        return PROFESSIONS.register(name, () -> {
            PoiType poiPredicate = HedgemodModVillagerProfessions.POI_TYPES.get((Object)name).poiType;
            return new VillagerProfession("hedgemod:" + name, poiPredicate, ImmutableSet.of(), ImmutableSet.of(), (SoundEvent)soundEvent.get());
        });
    }

    @SubscribeEvent
    public static void registerProfessionPointsOfInterest(RegistryEvent.Register<PoiType> event) {
        for (Map.Entry<String, ProfessionPoiType> entry : POI_TYPES.entrySet()) {
            Block block = entry.getValue().block.get();
            String name = entry.getKey();
            Optional existingCheck = PoiType.m_27390_((BlockState)block.m_49966_());
            if (existingCheck.isPresent()) {
                HedgemodMod.LOGGER.error("Skipping villager profession " + name + " that uses POI block " + String.valueOf(block) + " that is already in use by " + String.valueOf(existingCheck));
                continue;
            }
            PoiType poiType = (PoiType)new PoiType(name, (Set)ImmutableSet.copyOf((Collection)block.m_49965_().m_61056_()), 1, 1).setRegistryName("hedgemod:" + name);
            event.getRegistry().register((IForgeRegistryEntry)poiType);
            entry.getValue().poiType = poiType;
        }
    }

    private static class ProfessionPoiType {
        final Supplier<Block> block;
        PoiType poiType;

        ProfessionPoiType(Supplier<Block> block, PoiType poiType) {
            this.block = block;
            this.poiType = poiType;
        }
    }
}

