/*
 * Decompiled with CFR 0.152.
 */
package simplexity.simplevanish;

import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import simplexity.simplevanish.commands.FakeCommand;
import simplexity.simplevanish.commands.Vanish;
import simplexity.simplevanish.commands.VanishReload;
import simplexity.simplevanish.commands.VanishSettings;
import simplexity.simplevanish.commands.settings.AttackEntities;
import simplexity.simplevanish.commands.settings.BreakBlocks;
import simplexity.simplevanish.commands.settings.Invulnerability;
import simplexity.simplevanish.commands.settings.JoinSilently;
import simplexity.simplevanish.commands.settings.LeaveSilently;
import simplexity.simplevanish.commands.settings.MobsTarget;
import simplexity.simplevanish.commands.settings.NightVision;
import simplexity.simplevanish.commands.settings.OpenContainer;
import simplexity.simplevanish.commands.settings.Persist;
import simplexity.simplevanish.commands.settings.PickupItems;
import simplexity.simplevanish.commands.settings.VanishNotifications;
import simplexity.simplevanish.config.ConfigHandler;
import simplexity.simplevanish.config.Message;
import simplexity.simplevanish.hooks.VanishPlaceholders;
import simplexity.simplevanish.listeners.AttackListener;
import simplexity.simplevanish.listeners.BlockBreakListener;
import simplexity.simplevanish.listeners.BlockInteractListener;
import simplexity.simplevanish.listeners.ItemPickupListener;
import simplexity.simplevanish.listeners.PingServerListener;
import simplexity.simplevanish.listeners.PlayerJoinListener;
import simplexity.simplevanish.listeners.PlayerLeaveListener;
import simplexity.simplevanish.listeners.PreCommandListener;
import simplexity.simplevanish.listeners.TargetListener;
import simplexity.simplevanish.listeners.TrialSpawnListener;
import simplexity.simplevanish.listeners.VaultStateListener;
import simplexity.simplevanish.objects.VanishPermission;
import simplexity.simplevanish.saving.Cache;
import simplexity.simplevanish.saving.SqlHandler;

public final class SimpleVanish
extends JavaPlugin {
    private static SimpleVanish instance;
    private static boolean papiEnabled;
    private static boolean plexmapEnabled;
    private static final MiniMessage miniMessage;

    public static boolean isPapiEnabled() {
        return papiEnabled;
    }

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        ConfigHandler.getInstance().loadConfigValues();
        SqlHandler.getInstance().init();
        this.registerCommands();
        this.registerSubCommands();
        this.registerListeners();
        this.checkForPapi();
        this.checkForPlexmap();
    }

    private void registerCommands() {
        this.getCommand("vanish").setExecutor((CommandExecutor)new Vanish());
        this.getCommand("vsettings").setExecutor((CommandExecutor)new VanishSettings());
        this.getCommand("vanish-reload").setExecutor((CommandExecutor)new VanishReload());
        this.getCommand("fake").setExecutor((CommandExecutor)new FakeCommand());
    }

    private void registerSubCommands() {
        Cache.getSubCommands().clear();
        Cache.getSubCommands().add(new AttackEntities(VanishPermission.ATTACK_ENTITIES, "attack-entities", Message.SETTING_INSERT_ATTACK_ENTITIES.getMessage()));
        Cache.getSubCommands().add(new BreakBlocks(VanishPermission.BREAK_BLOCKS, "break-blocks", Message.SETTING_INSERT_BREAK_BLOCKS.getMessage()));
        Cache.getSubCommands().add(new Invulnerability(VanishPermission.INVULNERABLE, "invulnerability", Message.SETTING_INSERT_INVULNERABLE.getMessage()));
        Cache.getSubCommands().add(new JoinSilently(VanishPermission.SILENT_JOIN, "silent-join", Message.SETTING_INSERT_SILENT_JOIN.getMessage()));
        Cache.getSubCommands().add(new LeaveSilently(VanishPermission.SILENT_LEAVE, "silent-leave", Message.SETTING_INSERT_SILENT_LEAVE.getMessage()));
        Cache.getSubCommands().add(new MobsTarget(VanishPermission.MOBS_TARGET, "mobs-target", Message.SETTING_INSERT_MOBS_TARGET.getMessage()));
        Cache.getSubCommands().add(new NightVision(VanishPermission.NIGHT_VISION, "night-vision", Message.SETTING_INSERT_NIGHT_VISION.getMessage()));
        Cache.getSubCommands().add(new OpenContainer(VanishPermission.OPEN_CONTAINERS, "open-container", Message.SETTING_INSERT_OPEN_CONTAINERS.getMessage()));
        Cache.getSubCommands().add(new Persist(VanishPermission.PERSIST, "vanish-persist", Message.SETTING_INSERT_PERSIST.getMessage()));
        Cache.getSubCommands().add(new PickupItems(VanishPermission.PICK_UP_ITEMS, "pick-up-items", Message.SETTING_INSERT_PICK_UP_ITEMS.getMessage()));
        Cache.getSubCommands().add(new VanishNotifications(VanishPermission.VIEW_MESSAGES, "notifications", Message.SETTING_INSERT_VANISH_NOTIFICATIONS.getMessage()));
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new AttackListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockBreakListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockInteractListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ItemPickupListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PingServerListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerLeaveListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new TargetListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PreCommandListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new TrialSpawnListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new VaultStateListener(), (Plugin)this);
    }

    private void checkForPapi() {
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            papiEnabled = true;
            new VanishPlaceholders().register();
        } else {
            this.getLogger().info("You do not have PlaceholderAPI loaded on your server. Any PlaceholderAPI placeholders used in this plugin's messages, will not work.");
        }
    }

    private void checkForPlexmap() {
        if (this.getServer().getPluginManager().getPlugin("Pl3xMap") != null) {
            plexmapEnabled = true;
        }
    }

    public static boolean isPlexmapEnabled() {
        return plexmapEnabled;
    }

    public static SimpleVanish getInstance() {
        return instance;
    }

    public static MiniMessage getMiniMessage() {
        return miniMessage;
    }

    public void onDisable() {
        SqlHandler.getInstance().closeConnection();
    }

    static {
        papiEnabled = false;
        plexmapEnabled = false;
        miniMessage = MiniMessage.miniMessage();
    }
}

