/*
 * Decompiled with CFR 0.152.
 */
package simplexity.simplevanish.commands;

import java.util.List;
import java.util.Set;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import simplexity.simplevanish.config.Message;
import simplexity.simplevanish.handling.FakeJoinHandler;
import simplexity.simplevanish.handling.FakeLeaveHandler;

public class FakeCommand
implements TabExecutor {
    private final Set<String> allowedArgs = Set.of("leave", "join");

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length < 1) {
            sender.sendRichMessage(Message.ERROR_NOT_ENOUGH_ARGUMENTS.getMessage(), new TagResolver[]{Placeholder.parsed((String)"args", (String)"<leave|join>")});
            return false;
        }
        if (!(sender instanceof Player)) {
            this.handleConsoleSender(sender, args);
            return true;
        }
        Player player = (Player)sender;
        String leaveOrJoin = args[0];
        if (!this.allowedArgs.contains(leaveOrJoin.toLowerCase())) {
            player.sendRichMessage(Message.ERROR_INVALID_SUBCOMMAND.getMessage(), new TagResolver[]{Placeholder.parsed((String)"value", (String)leaveOrJoin)});
            return false;
        }
        if (leaveOrJoin.equalsIgnoreCase("leave")) {
            FakeLeaveHandler.getInstance().sendFakeLeaveMessage(player);
            return false;
        }
        if (leaveOrJoin.equalsIgnoreCase("join")) {
            FakeJoinHandler.getInstance().sendFakeJoinMessage(player);
            return true;
        }
        return false;
    }

    private void handleConsoleSender(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendRichMessage(Message.ERROR_NOT_ENOUGH_ARGUMENTS.getMessage(), new TagResolver[]{Placeholder.parsed((String)"args", (String)"<leave|join> <player>")});
            return;
        }
        String leaveOrJoin = args[0];
        if (!this.allowedArgs.contains(leaveOrJoin.toLowerCase())) {
            sender.sendRichMessage(Message.ERROR_INVALID_SUBCOMMAND.getMessage(), new TagResolver[]{Placeholder.parsed((String)"value", (String)leaveOrJoin)});
            return;
        }
        Player player = Bukkit.getPlayer((String)args[1]);
        if (player == null) {
            sender.sendRichMessage(Message.ERROR_NO_TARGET_PLAYER_FOUND.getMessage(), new TagResolver[]{Placeholder.parsed((String)"name", (String)args[1])});
            return;
        }
        if (leaveOrJoin.equalsIgnoreCase("leave")) {
            FakeLeaveHandler.getInstance().sendFakeLeaveMessage(player);
            return;
        }
        if (leaveOrJoin.equalsIgnoreCase("join")) {
            FakeJoinHandler.getInstance().sendFakeJoinMessage(player);
        }
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length < 1) {
            return List.of("leave", "join");
        }
        return null;
    }
}

