/*
 * Decompiled with CFR 0.152.
 */
package simplexity.simplevanish.commands;

import java.util.UUID;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import simplexity.simplevanish.config.Message;
import simplexity.simplevanish.objects.PlayerVanishSettings;
import simplexity.simplevanish.saving.Cache;

public abstract class SubCommand {
    public final Permission commandPermission;
    public final String commandName;
    public final String settingName;

    public SubCommand(Permission commandPermission, String commandName, String settingName) {
        this.commandPermission = commandPermission;
        this.commandName = commandName;
        this.settingName = settingName;
    }

    public Permission getCommandPermission() {
        return this.commandPermission;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getSettingName() {
        return this.settingName;
    }

    public abstract void execute(Player var1, boolean var2);

    public abstract boolean isEnabled(Player var1);

    public void sendMessage(Player player, boolean enabled) {
        if (enabled) {
            player.sendRichMessage(Message.SETTING_CHANGED.getMessage(), new TagResolver[]{Placeholder.parsed((String)"value", (String)Message.SETTING_INSERT_ENABLED.getMessage()), Placeholder.parsed((String)"setting", (String)this.getSettingName())});
            return;
        }
        player.sendRichMessage(Message.SETTING_CHANGED.getMessage(), new TagResolver[]{Placeholder.parsed((String)"value", (String)Message.SETTING_INSERT_DISABLED.getMessage()), Placeholder.parsed((String)"setting", (String)this.getSettingName())});
    }

    public PlayerVanishSettings getSettings(Player player) {
        UUID uuid = player.getUniqueId();
        return Cache.getVanishSettings(uuid);
    }
}

