/*
 * Decompiled with CFR 0.152.
 */
package simplexity.simplevanish.commands;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import simplexity.simplevanish.SimpleVanish;
import simplexity.simplevanish.commands.SubCommand;
import simplexity.simplevanish.config.Message;
import simplexity.simplevanish.saving.Cache;

public class VanishSettings
implements TabExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendRichMessage(Message.ERROR_MUST_BE_PLAYER.getMessage());
            return false;
        }
        Player player = (Player)sender;
        HashSet<SubCommand> subCommands = this.getCommandsUserCanAccess(player);
        if (subCommands.isEmpty()) {
            player.sendRichMessage(Message.ERROR_NO_PERMISSION.getMessage());
            return false;
        }
        if (args.length == 0) {
            player.sendMessage(this.displayCurrentSettings(player));
            return true;
        }
        String commandName = args[0];
        this.iterateSubCommands(player, subCommands, commandName, args);
        return false;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] strings) {
        if (!(commandSender instanceof Player)) {
            return List.of();
        }
        Player player = (Player)commandSender;
        if (strings.length > 1) {
            return List.of();
        }
        ArrayList<String> subCommands = new ArrayList<String>();
        for (SubCommand subCommand : this.getCommandsUserCanAccess(player)) {
            subCommands.add(subCommand.getCommandName());
        }
        return subCommands;
    }

    private HashSet<SubCommand> getCommandsUserCanAccess(Player player) {
        HashSet<SubCommand> commands = new HashSet<SubCommand>();
        for (SubCommand subCommand : Cache.getSubCommands()) {
            if (!player.hasPermission(subCommand.getCommandPermission())) continue;
            commands.add(subCommand);
        }
        return commands;
    }

    private Component displayCurrentSettings(Player player) {
        MiniMessage miniMessage = SimpleVanish.getMiniMessage();
        Component settingsMessage = miniMessage.deserialize((Object)Message.SETTING_LIST_HEADER.getMessage());
        for (SubCommand subCommand : Cache.getSubCommands()) {
            if (!player.hasPermission(subCommand.getCommandPermission())) continue;
            Component valueComponent = subCommand.isEnabled(player) ? miniMessage.deserialize((Object)Message.SETTING_INSERT_ENABLED.getMessage()) : miniMessage.deserialize((Object)Message.SETTING_INSERT_DISABLED.getMessage());
            Component appendableMessage = miniMessage.deserialize(Message.SETTING_LIST_ITEM.getMessage(), new TagResolver[]{Placeholder.parsed((String)"setting", (String)this.toTitleCase(subCommand.getCommandName())), Placeholder.component((String)"value", (ComponentLike)valueComponent)});
            settingsMessage = settingsMessage.append(appendableMessage);
        }
        return settingsMessage;
    }

    private void iterateSubCommands(Player player, HashSet<SubCommand> subCommands, String suppliedCommand, String[] args) {
        for (SubCommand subCommand : subCommands) {
            if (!subCommand.getCommandName().equalsIgnoreCase(suppliedCommand)) continue;
            boolean setEnabled = !subCommand.isEnabled(player);
            subCommand.execute(player, setEnabled);
            return;
        }
        player.sendRichMessage(Message.ERROR_INVALID_SUBCOMMAND.getMessage(), new TagResolver[]{Placeholder.unparsed((String)"value", (String)suppliedCommand)});
    }

    private String toTitleCase(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        String replaceDashes = string.replace("-", " ");
        String[] words = replaceDashes.split(" ");
        StringBuilder stringBuilder = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            stringBuilder.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1).toLowerCase()).append(" ");
        }
        return stringBuilder.toString().trim();
    }
}

