/*
 * Decompiled with CFR 0.152.
 */
package simplexity.simplevanish.commands.settings;

import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import simplexity.simplevanish.commands.SubCommand;
import simplexity.simplevanish.objects.PlayerVanishSettings;
import simplexity.simplevanish.saving.Cache;

public class NightVision
extends SubCommand {
    public static final PotionEffect nightVision = new PotionEffect(PotionEffectType.NIGHT_VISION, -1, 0, false, false, false);

    public NightVision(Permission commandPermission, String commandName, String settingName) {
        super(commandPermission, commandName, settingName);
    }

    @Override
    public void execute(Player player, boolean enabled) {
        PlayerVanishSettings settings = this.getSettings(player);
        settings.setNightVision(enabled);
        Cache.saveSettings(player.getUniqueId(), settings);
        this.sendMessage(player, enabled);
        this.updateCurrentNightVision(player, enabled);
    }

    @Override
    public boolean isEnabled(Player player) {
        return this.getSettings(player).giveNightvision();
    }

    private void updateCurrentNightVision(Player player, boolean enabled) {
        if (!Cache.getVanishedPlayers().contains(player)) {
            return;
        }
        if (enabled) {
            player.addPotionEffect(nightVision);
        } else {
            player.removePotionEffect(PotionEffectType.NIGHT_VISION);
        }
    }
}

