/*
 * Decompiled with CFR 0.152.
 */
package simplexity.simplevanish.config;

import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import simplexity.simplevanish.SimpleVanish;
import simplexity.simplevanish.config.LocaleHandler;
import simplexity.simplevanish.handling.ScheduleHandler;

public class ConfigHandler {
    private final Logger logger = SimpleVanish.getInstance().getLogger();
    private static ConfigHandler instance;
    private boolean chatFakeJoin;
    private boolean chatFakeLeave;
    private boolean removeFromTablist;
    private boolean changeTablistFormat;
    private boolean glowWhileVanished;
    private boolean mysqlEnabled;
    private boolean removeFromServerList;
    private boolean removeFromSleepingPlayers;
    private boolean preventMessagingVanished;
    private boolean customJoinLeave;
    private boolean debug;
    private Long remindInterval;
    private String mysqlIP;
    private String databaseName;
    private String databaseUsername;
    private String databasePassword;
    private String customJoinMessage;
    private String customLeaveMessage;
    private final HashSet<Material> containersToBlock = new HashSet();

    public static ConfigHandler getInstance() {
        if (instance == null) {
            instance = new ConfigHandler();
        }
        return instance;
    }

    public void loadConfigValues() {
        SimpleVanish.getInstance().reloadConfig();
        LocaleHandler.getInstance().reloadLocale();
        ScheduleHandler.getInstance().stopScheduler();
        FileConfiguration config = SimpleVanish.getInstance().getConfig();
        this.containersToBlock.clear();
        this.reloadContainersToBlock(config);
        this.debug = config.getBoolean("debug", false);
        this.mysqlEnabled = config.getBoolean("mysql.enabled", false);
        this.mysqlIP = config.getString("mysql.ip", "localhost:3306");
        this.databaseName = config.getString("mysql.database-name", "vanish");
        this.databaseUsername = config.getString("mysql.username", "username1");
        this.databasePassword = config.getString("mysql.password", "badpassword!");
        this.chatFakeJoin = config.getBoolean("chat.fake-join-on-un-vanish", false);
        this.chatFakeLeave = config.getBoolean("chat.fake-leave-on-vanish", false);
        this.preventMessagingVanished = config.getBoolean("chat.prevent-direct-messages", true);
        this.customJoinLeave = config.getBoolean("chat.custom-message.enabled", false);
        this.customJoinMessage = config.getString("chat.custom-message.join", "<gray>[<green>+</green>]</gray> <displayname> <green>joined the game");
        this.customLeaveMessage = config.getString("chat.custom-message.leave", "<gray>[<dark_red>-</dark_red>]</gray> <displayname> <gray>left the game");
        this.removeFromTablist = config.getBoolean("remove-from.tablist", true);
        this.removeFromServerList = config.getBoolean("remove-from.server-list", true);
        this.removeFromSleepingPlayers = config.getBoolean("remove-from.required-sleeping-players", true);
        this.changeTablistFormat = config.getBoolean("view.change-tablist", false);
        this.glowWhileVanished = config.getBoolean("view.glow-while-vanished", true);
        boolean remindWhileVanished = config.getBoolean("remind-while-vanished", true);
        this.remindInterval = config.getLong("remind-interval-in-seconds", 10L);
        if (remindWhileVanished) {
            ScheduleHandler.getInstance().startScheduler();
        }
    }

    private void reloadContainersToBlock(FileConfiguration config) {
        List containerList = config.getStringList("prevent-opening");
        if (containerList.isEmpty()) {
            this.containersToBlock.clear();
            return;
        }
        for (String container : containerList) {
            Material material = Material.getMaterial((String)container);
            if (material == null) {
                this.logger.info(container + " is not a valid material, please check your config");
                continue;
            }
            this.containersToBlock.add(material);
        }
    }

    public boolean shouldChatFakeJoin() {
        return this.chatFakeJoin;
    }

    public boolean shouldChatFakeLeave() {
        return this.chatFakeLeave;
    }

    public boolean shouldRemoveFromTablist() {
        return this.removeFromTablist;
    }

    public boolean isMysqlEnabled() {
        return this.mysqlEnabled;
    }

    public String getMysqlIP() {
        return this.mysqlIP;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDatabaseUsername() {
        return this.databaseUsername;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public HashSet<Material> getContainersToBlock() {
        return this.containersToBlock;
    }

    public boolean shouldRemoveFromServerList() {
        return this.removeFromServerList;
    }

    public boolean shouldPreventMessagingVanished() {
        return this.preventMessagingVanished;
    }

    public boolean shouldRemoveFromSleepingPlayers() {
        return this.removeFromSleepingPlayers;
    }

    public Long getRemindInterval() {
        return this.remindInterval;
    }

    public boolean shouldChangeTablistFormat() {
        return this.changeTablistFormat;
    }

    public boolean shouldGlowWhileVanished() {
        return this.glowWhileVanished;
    }

    public String getCustomJoinMessage() {
        return this.customJoinMessage;
    }

    public String getCustomLeaveMessage() {
        return this.customLeaveMessage;
    }

    public boolean isCustomJoinLeave() {
        return this.customJoinLeave;
    }

    public boolean isDebug() {
        return this.debug;
    }
}

