/*
 * Decompiled with CFR 0.152.
 */
package simplexity.simplevanish.handling;

import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import simplexity.simplevanish.SimpleVanish;
import simplexity.simplevanish.config.ConfigHandler;
import simplexity.simplevanish.objects.PlayerVanishSettings;
import simplexity.simplevanish.objects.VanishPermission;
import simplexity.simplevanish.saving.Cache;

public class MessageHandler {
    private static final MiniMessage miniMessage = SimpleVanish.getMiniMessage();

    @NotNull
    public static Component parsePlayerMessage(@NotNull Player player, @NotNull String message) {
        if (!SimpleVanish.isPapiEnabled()) {
            return miniMessage.deserialize(message, new TagResolver[]{Placeholder.component((String)"displayname", (ComponentLike)player.displayName()), Placeholder.unparsed((String)"username", (String)player.getName())});
        }
        return miniMessage.deserialize(message, new TagResolver[]{MessageHandler.papiTag(player), Placeholder.component((String)"displayname", (ComponentLike)player.displayName()), Placeholder.unparsed((String)"username", (String)player.getName())});
    }

    @NotNull
    private static TagResolver papiTag(@NotNull Player player) {
        return TagResolver.resolver((String)"papi", (argumentQueue, context) -> {
            String papiPlaceholder = argumentQueue.popOr("PLACEHOLDER API NEEDS ARGUMENT").value();
            String parsedPlaceholder = PlaceholderAPI.setPlaceholders((Player)player, (String)("%" + papiPlaceholder + "%"));
            TextComponent componentPlaceholder = LegacyComponentSerializer.legacySection().deserialize(parsedPlaceholder);
            return Tag.inserting((Component)componentPlaceholder);
        });
    }

    public static void sendAdminNotification(@NotNull Player player, @Nullable String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            if (!MessageHandler.shouldSendVanishNotification(onlinePlayer, player)) continue;
            onlinePlayer.sendMessage(MessageHandler.parsePlayerMessage(player, message));
        }
    }

    public static boolean shouldSendVanishNotification(@NotNull Player onlinePlayer, @NotNull Player player) {
        if (!onlinePlayer.hasPermission(VanishPermission.VIEW_VANISHED)) {
            return false;
        }
        if (onlinePlayer.equals((Object)player)) {
            return false;
        }
        PlayerVanishSettings vanishSettings = Cache.getVanishSettings(onlinePlayer.getUniqueId());
        return !vanishSettings.viewVanishNotifications();
    }

    public static void debug(@NotNull String prefix, @NotNull String message, Object ... args) {
        if (ConfigHandler.getInstance().isDebug()) {
            message = prefix + (String)message;
            message = String.format((String)message, args);
            SimpleVanish.getInstance().getSLF4JLogger().info((String)message);
        }
    }
}

