/*
 * Decompiled with CFR 0.152.
 */
package simplexity.simplevanish.handling;

import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import simplexity.simplevanish.SimpleVanish;
import simplexity.simplevanish.config.ConfigHandler;
import simplexity.simplevanish.config.Message;
import simplexity.simplevanish.saving.Cache;

public class ScheduleHandler {
    private BukkitTask task;
    private final BukkitScheduler scheduler = SimpleVanish.getInstance().getServer().getScheduler();
    private final MiniMessage miniMessage = SimpleVanish.getMiniMessage();
    private static ScheduleHandler instance;

    private ScheduleHandler() {
    }

    public static ScheduleHandler getInstance() {
        if (instance == null) {
            instance = new ScheduleHandler();
        }
        return instance;
    }

    public void startScheduler() {
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = this.scheduler.runTaskTimer((Plugin)SimpleVanish.getInstance(), this::displayActionBar, 0L, ConfigHandler.getInstance().getRemindInterval() * 20L);
    }

    public void stopScheduler() {
        if (this.task != null) {
            this.task.cancel();
        }
    }

    private void displayActionBar() {
        if (Cache.getVanishedPlayers().isEmpty()) {
            return;
        }
        for (Player player : Cache.getVanishedPlayers()) {
            player.sendActionBar(this.miniMessage.deserialize((Object)Message.VANISH_REMINDER.getMessage()));
        }
    }
}

