/*
 * Decompiled with CFR 0.152.
 */
package simplexity.simplevanish.handling;

import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import simplexity.simplevanish.SimpleVanish;
import simplexity.simplevanish.commands.settings.NightVision;
import simplexity.simplevanish.config.ConfigHandler;
import simplexity.simplevanish.config.Message;
import simplexity.simplevanish.events.PlayerVanishEvent;
import simplexity.simplevanish.handling.FakeLeaveHandler;
import simplexity.simplevanish.handling.MessageHandler;
import simplexity.simplevanish.handling.UnvanishHandler;
import simplexity.simplevanish.hooks.PlexmapIntegration;
import simplexity.simplevanish.objects.PlayerVanishSettings;
import simplexity.simplevanish.objects.VanishPermission;
import simplexity.simplevanish.saving.Cache;
import simplexity.simplevanish.saving.SqlHandler;

public class VanishHandler {
    private static VanishHandler instance;

    public static VanishHandler getInstance() {
        if (instance == null) {
            instance = new VanishHandler();
        }
        return instance;
    }

    private VanishHandler() {
    }

    public void runVanishEvent(@NotNull Player player, boolean fakeLeave, @Nullable String notificationMessage) {
        PlayerVanishSettings settings = Cache.getVanishSettings(player.getUniqueId());
        PlayerVanishEvent vanishEvent = new PlayerVanishEvent(player, settings);
        Bukkit.getServer().getPluginManager().callEvent((Event)vanishEvent);
        if (vanishEvent.isCancelled()) {
            return;
        }
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            this.hidePlayer(onlinePlayer, player);
            this.removeFromTabList(onlinePlayer, player);
        }
        this.provideNightVision(player, settings);
        this.setInvulnerable(player, settings);
        this.removeFromSleepingPlayers(player);
        this.stopMobsTracking(player);
        this.changeTablist(player);
        this.giveGlow(player);
        player.setAffectsSpawning(false);
        Cache.getVanishedPlayers().add(player);
        settings.setVanished(true);
        SqlHandler.getInstance().savePlayerSettings(player.getUniqueId(), settings);
        if (fakeLeave) {
            FakeLeaveHandler.getInstance().sendFakeLeaveMessage(player);
        }
        if (SimpleVanish.isPlexmapEnabled()) {
            PlexmapIntegration.hideVanishedPlayer(player);
        }
        MessageHandler.sendAdminNotification(player, notificationMessage);
    }

    public void handlePlayerLeave(@NotNull Player player) {
        if (!Cache.getVanishSettings(player.getUniqueId()).shouldVanishPersist()) {
            UnvanishHandler.getInstance().runUnvanishEvent(player, false, "");
        } else {
            Cache.getVanishedPlayers().remove(player);
            Cache.removePlayerFromCache(player.getUniqueId());
        }
    }

    public void hideCurrentlyVanishedUsers(@NotNull Player player) {
        for (Player vanishedPlayer : Cache.getVanishedPlayers()) {
            this.hidePlayer(player, vanishedPlayer);
            this.removeFromTabList(player, vanishedPlayer);
        }
    }

    public void changeTablist(@NotNull Player player) {
        if (!ConfigHandler.getInstance().shouldChangeTablistFormat()) {
            return;
        }
        Component message = MessageHandler.parsePlayerMessage(player, Message.VIEW_TABLIST_FORMAT.getMessage());
        player.playerListName(message);
    }

    public void hidePlayer(@NotNull Player onlinePlayer, @NotNull Player playerToHide) {
        if (onlinePlayer.equals((Object)playerToHide)) {
            return;
        }
        if (onlinePlayer.hasPermission(VanishPermission.VIEW_VANISHED)) {
            return;
        }
        onlinePlayer.hidePlayer((Plugin)SimpleVanish.getInstance(), playerToHide);
    }

    public void removeFromTabList(@NotNull Player onlinePlayer, @NotNull Player playerToRemove) {
        if (!ConfigHandler.getInstance().shouldRemoveFromTablist()) {
            return;
        }
        if (onlinePlayer.equals((Object)playerToRemove)) {
            return;
        }
        if (onlinePlayer.hasPermission(VanishPermission.VIEW_TABLIST)) {
            return;
        }
        onlinePlayer.unlistPlayer(playerToRemove);
    }

    public void provideNightVision(@NotNull Player player, @NotNull PlayerVanishSettings settings) {
        if (!player.hasPermission(VanishPermission.NIGHT_VISION)) {
            return;
        }
        if (!settings.giveNightvision()) {
            return;
        }
        player.addPotionEffect(NightVision.nightVision);
    }

    public void setInvulnerable(@NotNull Player player, @NotNull PlayerVanishSettings settings) {
        if (!player.hasPermission(VanishPermission.INVULNERABLE)) {
            return;
        }
        if (!settings.shouldGiveInvulnerability()) {
            return;
        }
        player.setInvulnerable(true);
    }

    public void removeFromSleepingPlayers(@NotNull Player player) {
        if (!ConfigHandler.getInstance().shouldRemoveFromSleepingPlayers()) {
            return;
        }
        player.setSleepingIgnored(true);
    }

    public void giveGlow(@NotNull Player player) {
        if (!ConfigHandler.getInstance().shouldGlowWhileVanished()) {
            return;
        }
        player.setGlowing(true);
    }

    public void stopMobsTracking(@NotNull Player player) {
        List nearbyEntities = player.getNearbyEntities(16.0, 16.0, 16.0);
        for (Entity entity : nearbyEntities) {
            Mob mob;
            LivingEntity targetEntity;
            if (!(entity instanceof Mob) || (targetEntity = (mob = (Mob)entity).getTarget()) == null || !targetEntity.equals((Object)player)) continue;
            mob.setTarget(null);
        }
    }
}

