/*
 * Decompiled with CFR 0.152.
 */
package simplexity.simplevanish.listeners;

import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import simplexity.simplevanish.config.ConfigHandler;
import simplexity.simplevanish.listeners.ListenerUtils;
import simplexity.simplevanish.objects.PlayerVanishSettings;
import simplexity.simplevanish.objects.VanishPermission;
import simplexity.simplevanish.saving.Cache;

public class BlockInteractListener
implements Listener {
    @EventHandler
    public void onContainerOpen(PlayerInteractEvent interactEvent) {
        if (!interactEvent.hasBlock()) {
            return;
        }
        if (interactEvent.getHand() == null) {
            return;
        }
        if (interactEvent.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        Player player = interactEvent.getPlayer();
        if (ListenerUtils.userNotVanished(player)) {
            return;
        }
        Block block = interactEvent.getClickedBlock();
        if (block == null) {
            return;
        }
        if (!ConfigHandler.getInstance().getContainersToBlock().contains(block.getType())) {
            return;
        }
        if (this.interactionEnabled(player)) {
            return;
        }
        interactEvent.setCancelled(true);
    }

    private boolean interactionEnabled(Player player) {
        PlayerVanishSettings vanishSettings = Cache.getVanishSettings(player.getUniqueId());
        if (player.hasPermission(VanishPermission.OPEN_CONTAINERS) && vanishSettings.shouldContainersOpen()) {
            return true;
        }
        return player.hasPermission(VanishPermission.OPEN_CONTAINERS) && player.isSneaking();
    }
}

