/*
 * Decompiled with CFR 0.152.
 */
package simplexity.simplevanish.listeners;

import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import simplexity.simplevanish.config.ConfigHandler;
import simplexity.simplevanish.config.Message;
import simplexity.simplevanish.objects.VanishPermission;
import simplexity.simplevanish.saving.Cache;

public class PreCommandListener
implements Listener {
    @EventHandler
    public void onCommand(PlayerCommandPreprocessEvent event) {
        if (!ConfigHandler.getInstance().shouldPreventMessagingVanished()) {
            return;
        }
        if (!this.isMessageCommand(event.getMessage())) {
            return;
        }
        if (Cache.getVanishedPlayers().isEmpty()) {
            return;
        }
        if (event.getPlayer().hasPermission(VanishPermission.VIEW_VANISHED)) {
            return;
        }
        if (!this.isTryingToMessageVanishedPlayer(event.getMessage())) {
            return;
        }
        Player player = event.getPlayer();
        event.setCancelled(true);
        player.sendRichMessage(Message.ERROR_NO_PLAYER_FOUND_TRANSLATABLE.getMessage());
    }

    private boolean isMessageCommand(String message) {
        if ((message = message.toLowerCase()).startsWith("/minecraft:msg")) {
            return true;
        }
        if (message.startsWith("/minecraft:w")) {
            return true;
        }
        if (message.startsWith("/minecraft:tell")) {
            return true;
        }
        if (message.startsWith("/msg")) {
            return true;
        }
        if (message.startsWith("/w")) {
            return true;
        }
        return message.startsWith("/tell");
    }

    private boolean isTryingToMessageVanishedPlayer(String message) {
        String[] args = message.split(" ");
        if (args.length < 2) {
            return false;
        }
        String username = args[1];
        Player target = Bukkit.getPlayer((String)username);
        return Cache.getVanishedPlayers().contains(target);
    }
}

