/*
 * Decompiled with CFR 0.152.
 */
package simplexity.simplevanish.saving;

import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.entity.Player;
import simplexity.simplevanish.commands.SubCommand;
import simplexity.simplevanish.objects.PlayerVanishSettings;
import simplexity.simplevanish.saving.SqlHandler;

public class Cache {
    private static final HashMap<UUID, PlayerVanishSettings> cachedSettings = new HashMap();
    private static final HashSet<SubCommand> subCommands = new HashSet();
    private static final HashSet<Player> vanishedPlayers = new HashSet();

    public static HashSet<Player> getVanishedPlayers() {
        return vanishedPlayers;
    }

    public static HashSet<SubCommand> getSubCommands() {
        return subCommands;
    }

    public static PlayerVanishSettings getVanishSettings(UUID uuid) {
        if (!cachedSettings.containsKey(uuid)) {
            SqlHandler.getInstance().updateSettings(uuid);
        }
        return cachedSettings.get(uuid);
    }

    public static void updateSettingsCache(UUID uuid, PlayerVanishSettings settings) {
        cachedSettings.remove(uuid);
        cachedSettings.put(uuid, settings);
    }

    public static void removePlayerFromCache(UUID uuid) {
        cachedSettings.remove(uuid);
    }

    public static void saveSettings(UUID uuid, PlayerVanishSettings settings) {
        SqlHandler.getInstance().savePlayerSettings(uuid, settings);
        Cache.updateSettingsCache(uuid, settings);
    }
}

