/*
 * Decompiled with CFR 0.152.
 */
package simplexity.simplevanish.saving;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import simplexity.simplevanish.SimpleVanish;
import simplexity.simplevanish.config.ConfigHandler;
import simplexity.simplevanish.handling.MessageHandler;
import simplexity.simplevanish.objects.PlayerVanishSettings;
import simplexity.simplevanish.saving.Cache;

public class SqlHandler {
    private static final HikariConfig hikariConfig = new HikariConfig();
    private static HikariDataSource dataSource;
    private static final int SCHEMA_VERSION = 1;
    private final Logger logger = SimpleVanish.getInstance().getSLF4JLogger();
    private final String mysqlUpdateStatement = "INSERT INTO vanish_settings (\n    player_uuid, is_vanished, vanish_persists, night_vision,\n    break_blocks, open_containers, attack_entities, mobs_target,\n    pickup_items, invulnerability, leave_silently, join_silently,\n    vanish_notifications\n) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\nON DUPLICATE KEY UPDATE\n    is_vanished = VALUES(is_vanished),\n    vanish_persists = VALUES(vanish_persists),\n    night_vision = VALUES(night_vision),\n    break_blocks = VALUES(break_blocks),\n    open_containers = VALUES(open_containers),\n    attack_entities = VALUES(attack_entities),\n    mobs_target = VALUES(mobs_target),\n    pickup_items = VALUES(pickup_items),\n    invulnerability = VALUES(invulnerability),\n    leave_silently = VALUES(leave_silently),\n    join_silently = VALUES(join_silently),\n    vanish_notifications = VALUES(vanish_notifications);\n";
    private final String selectionStatement = "SELECT is_vanished, vanish_persists, night_vision,\nbreak_blocks, open_containers, attack_entities,\nmobs_target, pickup_items, invulnerability,\nleave_silently, join_silently, vanish_notifications\nFROM vanish_settings WHERE player_uuid = ?\n";
    private final String sqliteUpdateStatement = "INSERT INTO vanish_settings (\n    player_uuid, is_vanished, vanish_persists, night_vision,\n    break_blocks, open_containers, attack_entities, mobs_target,\n    pickup_items, invulnerability, leave_silently, join_silently,\n    vanish_notifications\n) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\nON CONFLICT(player_uuid) DO UPDATE SET\n    is_vanished = excluded.is_vanished,\n    vanish_persists = excluded.vanish_persists,\n    night_vision = excluded.night_vision,\n    break_blocks = excluded.break_blocks,\n    open_containers = excluded.open_containers,\n    attack_entities = excluded.attack_entities,\n    mobs_target = excluded.mobs_target,\n    pickup_items = excluded.pickup_items,\n    invulnerability = excluded.invulnerability,\n    leave_silently = excluded.leave_silently,\n    join_silently = excluded.join_silently,\n    vanish_notifications = excluded.vanish_notifications;\n";
    private static SqlHandler instance;

    private SqlHandler() {
    }

    public static SqlHandler getInstance() {
        if (instance == null) {
            instance = new SqlHandler();
        }
        return instance;
    }

    public void init() {
        this.debug("Initializing SQL Handler...", new Object[0]);
        this.setupConfig();
        try {
            this.debug("Creating vanish_settings table if missing.", new Object[0]);
            this.initializeTables();
            this.debug("Verifying schema version and applying migrations if needed.", new Object[0]);
            this.versionChecks();
        }
        catch (SQLException e) {
            this.logger.warn("Failed to initialize database. Error: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void savePlayerSettings(@NotNull UUID uuid, @NotNull PlayerVanishSettings settings) {
        this.debug("Saving vanish settings for player %s", uuid);
        String updateStatement = ConfigHandler.getInstance().isMysqlEnabled() ? "INSERT INTO vanish_settings (\n    player_uuid, is_vanished, vanish_persists, night_vision,\n    break_blocks, open_containers, attack_entities, mobs_target,\n    pickup_items, invulnerability, leave_silently, join_silently,\n    vanish_notifications\n) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\nON DUPLICATE KEY UPDATE\n    is_vanished = VALUES(is_vanished),\n    vanish_persists = VALUES(vanish_persists),\n    night_vision = VALUES(night_vision),\n    break_blocks = VALUES(break_blocks),\n    open_containers = VALUES(open_containers),\n    attack_entities = VALUES(attack_entities),\n    mobs_target = VALUES(mobs_target),\n    pickup_items = VALUES(pickup_items),\n    invulnerability = VALUES(invulnerability),\n    leave_silently = VALUES(leave_silently),\n    join_silently = VALUES(join_silently),\n    vanish_notifications = VALUES(vanish_notifications);\n" : "INSERT INTO vanish_settings (\n    player_uuid, is_vanished, vanish_persists, night_vision,\n    break_blocks, open_containers, attack_entities, mobs_target,\n    pickup_items, invulnerability, leave_silently, join_silently,\n    vanish_notifications\n) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\nON CONFLICT(player_uuid) DO UPDATE SET\n    is_vanished = excluded.is_vanished,\n    vanish_persists = excluded.vanish_persists,\n    night_vision = excluded.night_vision,\n    break_blocks = excluded.break_blocks,\n    open_containers = excluded.open_containers,\n    attack_entities = excluded.attack_entities,\n    mobs_target = excluded.mobs_target,\n    pickup_items = excluded.pickup_items,\n    invulnerability = excluded.invulnerability,\n    leave_silently = excluded.leave_silently,\n    join_silently = excluded.join_silently,\n    vanish_notifications = excluded.vanish_notifications;\n";
        try (Connection conn = SqlHandler.getConnection();
             PreparedStatement statement = conn.prepareStatement(updateStatement);){
            statement.setString(1, uuid.toString());
            statement.setBoolean(2, settings.isVanished());
            statement.setBoolean(3, settings.shouldVanishPersist());
            statement.setBoolean(4, settings.giveNightvision());
            statement.setBoolean(5, settings.canBreakBlocks());
            statement.setBoolean(6, settings.shouldContainersOpen());
            statement.setBoolean(7, settings.canAttackEntities());
            statement.setBoolean(8, settings.shouldMobsTarget());
            statement.setBoolean(9, settings.shouldPickupItems());
            statement.setBoolean(10, settings.shouldGiveInvulnerability());
            statement.setBoolean(11, settings.shouldLeaveSilently());
            statement.setBoolean(12, settings.shouldJoinSilently());
            statement.setBoolean(13, settings.viewVanishNotifications());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.logger.warn("Failed to save player settings to database. Error: {}", (Object)e.getMessage(), (Object)e);
        }
        Cache.updateSettingsCache(uuid, settings);
    }

    public void updateSettings(@NotNull UUID uuid) {
        this.debug("Loading vanish settings for player %s", uuid);
        try (Connection conn = SqlHandler.getConnection();
             PreparedStatement statement = conn.prepareStatement("SELECT is_vanished, vanish_persists, night_vision,\nbreak_blocks, open_containers, attack_entities,\nmobs_target, pickup_items, invulnerability,\nleave_silently, join_silently, vanish_notifications\nFROM vanish_settings WHERE player_uuid = ?\n");){
            statement.setString(1, uuid.toString());
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next()) {
                    PlayerVanishSettings settings = new PlayerVanishSettings(resultSet.getBoolean("is_vanished"), resultSet.getBoolean("vanish_persists"), resultSet.getBoolean("night_vision"), resultSet.getBoolean("break_blocks"), resultSet.getBoolean("open_containers"), resultSet.getBoolean("attack_entities"), resultSet.getBoolean("mobs_target"), resultSet.getBoolean("pickup_items"), resultSet.getBoolean("invulnerability"), resultSet.getBoolean("leave_silently"), resultSet.getBoolean("join_silently"), resultSet.getBoolean("vanish_notifications"));
                    Cache.updateSettingsCache(uuid, settings);
                } else {
                    PlayerVanishSettings settings = new PlayerVanishSettings();
                    Cache.updateSettingsCache(uuid, settings);
                    this.savePlayerSettings(uuid, settings);
                }
            }
        }
        catch (SQLException e) {
            this.logger.warn("Failed to get vanish settings from database. Error: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void initializeTables() throws SQLException {
        Connection connection = SqlHandler.getConnection();
        PreparedStatement initializationStatement = connection.prepareStatement("    CREATE TABLE IF NOT EXISTS vanish_settings (\n    player_uuid VARCHAR(36) PRIMARY KEY,\n    is_vanished BOOLEAN NOT NULL,\n    vanish_persists BOOLEAN NOT NULL,\n    night_vision BOOLEAN NOT NULL,\n    break_blocks BOOLEAN NOT NULL,\n    open_containers BOOLEAN NOT NULL,\n    attack_entities BOOLEAN NOT NULL,\n    mobs_target BOOLEAN NOT NULL,\n    pickup_items BOOLEAN NOT NULL,\n    invulnerability BOOLEAN NOT NULL,\n    leave_silently BOOLEAN NOT NULL,\n    join_silently BOOLEAN NOT NULL,\n    vanish_notifications BOOLEAN NOT NULL\n);");
        initializationStatement.execute();
    }

    public void versionChecks() throws SQLException {
        this.debug("Ensuring schema_version table exists...", new Object[0]);
        Connection connection = SqlHandler.getConnection();
        PreparedStatement versionStatement = connection.prepareStatement("CREATE TABLE IF NOT EXISTS schema_version (\n    version INTEGER NOT NULL\n);\n");
        versionStatement.execute();
        PreparedStatement checkVersion = connection.prepareStatement("SELECT COUNT(*) FROM schema_version;");
        ResultSet versionCheck = checkVersion.executeQuery();
        if (versionCheck.next() && versionCheck.getInt(1) == 0) {
            PreparedStatement insertVersion = connection.prepareStatement("INSERT INTO schema_version (version) VALUES (?);");
            insertVersion.setInt(1, 1);
            insertVersion.executeUpdate();
            this.debug("Inserted initial schema version %d", 1);
        } else {
            int currentVersion = this.getSchemaVersion();
            this.debug("Current schema version is: %d", currentVersion);
            if (currentVersion < 1) {
                this.runMigrations(connection, currentVersion);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getSchemaVersion() {
        this.debug("Checking schema version...", new Object[0]);
        try (Connection connection = SqlHandler.getConnection();){
            PreparedStatement statement = connection.prepareStatement("SELECT version FROM schema_version LIMIT 1;");
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                int version = resultSet.getInt("version");
                this.debug("Retrieved schema version: %d", version);
                int n2 = version;
                return n2;
            }
            this.debug("Schema version table exists but no version found, returning -1", new Object[0]);
            int n = -1;
            return n;
        }
        catch (SQLException e) {
            this.logger.warn("Failed to get schema version", e);
            return -1;
        }
    }

    public void runMigrations(@NotNull Connection connection, int fromVersion) {
        try {
            this.debug("Running migrations from schema version %d to %d", fromVersion, 1);
            PreparedStatement updateVersion = connection.prepareStatement("UPDATE schema_version SET version = ?;");
            updateVersion.setInt(1, 1);
            updateVersion.executeUpdate();
            this.debug("Schema upgraded to version %d", 1);
        }
        catch (SQLException e) {
            this.logger.error("Error running schema migrations", e);
        }
    }

    public static Connection getConnection() throws SQLException {
        return dataSource.getConnection();
    }

    public void setupConfig() {
        if (ConfigHandler.getInstance().isMysqlEnabled()) {
            this.debug("Setting Hikari Config Settings...", new Object[0]);
            this.debug("Using MySQL", new Object[0]);
            hikariConfig.setJdbcUrl("jdbc:mysql://" + ConfigHandler.getInstance().getMysqlIP() + "/" + ConfigHandler.getInstance().getDatabaseName());
            hikariConfig.setUsername(ConfigHandler.getInstance().getDatabaseUsername());
            hikariConfig.setPassword(ConfigHandler.getInstance().getDatabasePassword());
            dataSource = new HikariDataSource(hikariConfig);
            return;
        }
        this.debug("Setting Hikari Config Settings...", new Object[0]);
        this.debug("Using SQLite", new Object[0]);
        hikariConfig.setJdbcUrl("jdbc:sqlite:" + String.valueOf(SimpleVanish.getInstance().getDataFolder()) + "/vanish-settings.db");
        hikariConfig.setConnectionTestQuery("PRAGMA journal_mode = WAL;");
        dataSource = new HikariDataSource(hikariConfig);
    }

    public void closeConnection() {
        this.debug("Closing connection to database", new Object[0]);
        if (dataSource != null && !dataSource.isClosed()) {
            dataSource.close();
        }
    }

    private void debug(@NotNull String message, Object ... args) {
        MessageHandler.debug("[SQL Handler] ", message, args);
    }
}

