/*
 * Decompiled with CFR 0.152.
 */
package com.notium.bettercapes.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.UUID;

public final class UUIDAdapter
implements JsonDeserializer<UUID> {
    public UUID deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) {
        if (json == null || json.isJsonNull()) {
            return null;
        }
        if (json.isJsonPrimitive()) {
            return this.parseUuidString(json.getAsString());
        }
        if (json.isJsonObject()) {
            JsonObject obj = json.getAsJsonObject();
            JsonElement value = null;
            if (obj.has("UUID")) {
                value = obj.get("UUID");
            } else if (obj.has("uuid")) {
                value = obj.get("uuid");
            }
            if (value != null && value.isJsonPrimitive()) {
                return this.parseUuidString(value.getAsString());
            }
            return new UUID(0L, 0L);
        }
        return new UUID(0L, 0L);
    }

    private UUID parseUuidString(String raw) {
        if (raw == null) {
            return null;
        }
        if ((raw = raw.trim()).isEmpty()) {
            return null;
        }
        if (raw.indexOf(45) >= 0) {
            try {
                return UUID.fromString(raw);
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException("Invalid UUID: " + raw, (Throwable)e);
            }
        }
        String hex = raw.toLowerCase(Locale.ROOT);
        if (hex.matches("[0-9a-f]{32}")) {
            String dashed = hex.substring(0, 8) + "-" + hex.substring(8, 12) + "-" + hex.substring(12, 16) + "-" + hex.substring(16, 20) + "-" + hex.substring(20);
            try {
                return UUID.fromString(dashed);
            }
            catch (IllegalArgumentException e) {
                return new UUID(0L, 0L);
            }
        }
        return new UUID(0L, 0L);
    }
}

