/*
 * Decompiled with CFR 0.152.
 */
package com.notium.bettercapes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.notium.bettercapes.api.SkinApi;
import com.notium.bettercapes.config.ConfigEntryMapAdapter;
import com.notium.bettercapes.config.ConfigHandler;
import com.notium.bettercapes.config.UUIDAdapter;
import com.notium.bettercapes.data.BuiltinCapesHandler;
import com.notium.bettercapes.data.PlayerCapeDataHandler;
import com.notium.bettercapes.data.TabListDataHandler;
import com.notium.bettercapes.data.cape.Cape;
import com.notium.bettercapes.data.cape.CapeDeserializer;
import com.notium.bettercapes.screen.CapeSelectScreen;
import com.notium.bettercapes.screen.CustomCapeSelectScreen;
import com.notium.bettercapes.screen.OutdatedClientScreen;
import com.notium.bettercapes.screen.widget.capeplayer.CapePlayerGuiElementRenderer;
import com.notium.bettercapes.websocket.ConnectionHandler;
import com.notium.bettercapes.websocket.packet.c2s.authentication.RequestAuthenticationServerIdC2SPacket;
import com.notium.bettercapes.websocket.packet.s2c.OutdatedClientS2CPacket;
import com.notium.bettercapes.websocket.packet.s2c.S2CPacket;
import com.notium.bettercapes.websocket.packet.s2c.S2CPacketDeserializer;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.SpecialGuiElementRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_320;
import net.minecraft.class_3675;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BetterCapes
implements ModInitializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "bettercapes";
    public static final String CLIENT_VERSION = "1.4.1";
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(S2CPacket.class, (Object)new S2CPacketDeserializer()).registerTypeAdapter(Cape.class, (Object)new CapeDeserializer()).registerTypeAdapter(new TypeToken<HashMap<ConfigHandler.ConfigEntryType, String>>(){}.getType(), (Object)new ConfigEntryMapAdapter()).registerTypeAdapter(UUID.class, (Object)new UUIDAdapter()).create();
    private static class_320 session;
    private static class_304 openSelectCapeScreen;
    private static class_304 openSelectCustomCapeScreen;
    private static class_1937 prevWorld;

    public static Logger getLogger() {
        return LOGGER;
    }

    public static Gson getGson() {
        return gson;
    }

    public void onInitialize() {
        session = class_310.method_1551().method_1548();
        class_310.method_1551().execute(() -> {
            ConfigHandler.getInstance().loadConfig();
            SkinApi.updateSkin();
            BuiltinCapesHandler.getInstance().loadCapes();
            Executors.newSingleThreadExecutor().submit(OutdatedClientS2CPacket::handleOnOutdatedClient);
        });
        class_304.class_11900 category = class_304.class_11900.method_74698((class_2960)class_2960.method_60654((String)MOD_ID));
        SpecialGuiElementRegistry.register(ctx -> new CapePlayerGuiElementRenderer(ctx.vertexConsumers()));
        openSelectCapeScreen = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Show Cape Selection Screen", class_3675.class_307.field_1668, 78, category));
        openSelectCustomCapeScreen = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Show Custom Cape Selection Screen", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), category));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (openSelectCapeScreen.method_1436()) {
                BetterCapes.openScreenOrOutdatedClientScreen(new CapeSelectScreen(null, BuiltinCapesHandler.getInstance().getLoadedCapes()), null);
            }
            if (openSelectCustomCapeScreen.method_1436()) {
                BetterCapes.openScreenOrOutdatedClientScreen(new CustomCapeSelectScreen(null, ConfigHandler.getInstance().getCapeCustom()), null);
            }
            if (client.field_1687 != null) {
                List<UUID> uuids = client.field_1687.method_18456().stream().map(class_1297::method_5667).toList();
                PlayerCapeDataHandler.getInstance().removePlayers(uuids);
            }
            if (session != client.method_1548()) {
                session = client.method_1548();
                ConnectionHandler.getInstance().sendC2SPacket(new RequestAuthenticationServerIdC2SPacket());
                SkinApi.updateSkin();
            }
            if (client.field_1687 != prevWorld) {
                PlayerCapeDataHandler.getInstance().resetData();
                TabListDataHandler.getInstance().resetData();
                prevWorld = client.field_1687;
            }
        });
    }

    public static void openScreenOrOutdatedClientScreen(class_437 screen, class_437 parent) {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        if (ConfigHandler.getInstance().getEntry(ConfigHandler.ConfigEntryType.OUTDATED_CLIENT, Boolean.class).booleanValue()) {
            OutdatedClientS2CPacket packet = ConfigHandler.getInstance().getEntry(ConfigHandler.ConfigEntryType.OUTDATED_CLIENT_DATA, OutdatedClientS2CPacket.class);
            if (packet == null || packet.newestVersion.equals(CLIENT_VERSION)) {
                ConfigHandler.getInstance().setEntry(ConfigHandler.ConfigEntryType.OUTDATED_CLIENT, "false");
                return;
            }
            client.execute(() -> client.method_1507((class_437)new OutdatedClientScreen(packet.modrinthUrl, packet.curseforgeUrl, packet.messages, parent)));
            return;
        }
        client.execute(() -> client.method_1507(screen));
    }

    public static void showInfoToast(String title, String description) {
        class_310.method_1551().execute(() -> {
            class_370.method_27024((class_374)class_310.method_1551().method_1566(), (class_370.class_9037)class_370.class_9037.field_47588, (class_2561)class_2561.method_30163((String)title), (class_2561)class_2561.method_30163((String)description));
            BetterCapes.getLogger().info("{} {}", (Object)title, (Object)(description == null ? "" : description));
        });
    }
}

