/*
 * Decompiled with CFR 0.152.
 */
package com.notium.bettercapes.api;

import com.notium.bettercapes.BetterCapes;
import com.notium.bettercapes.registry.TextureRegistry;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1068;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7920;
import net.minecraft.class_8685;

public class SkinApi {
    private static volatile SkinTextures skinTexture = SkinApi.getRandomDefaultSkin();

    public static SkinTextures getPlayerSkin() {
        if (class_310.method_1551().field_1724 != null) {
            class_8685 skinTextures = class_310.method_1551().field_1724.method_52814();
            return new SkinTextures(skinTextures.comp_1626().comp_3627(), skinTextures.comp_1629().equals((Object)class_7920.field_41122));
        }
        return skinTexture;
    }

    public static SkinTextures getLoadedSkinTextures() {
        return skinTexture;
    }

    public static void updateSkin() {
        skinTexture = SkinApi.getSkinData();
    }

    private static SkinTextures getSkinData() {
        UUID uuid = class_310.method_1551().method_1548().method_44717();
        try {
            URI uri = new URI("https://sessionserver.mojang.com/session/minecraft/profile/" + String.valueOf(uuid));
            HttpRequest request = HttpRequest.newBuilder().uri(uri).GET().build();
            HttpClient httpClient = HttpClient.newHttpClient();
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                PlayerProfile playerProfile = (PlayerProfile)BetterCapes.getGson().fromJson(response.body(), PlayerProfile.class);
                String data = new String(Base64.getDecoder().decode(playerProfile.properties.get((int)0).value));
                PlayerProfileInfo playerProfileInfo = (PlayerProfileInfo)BetterCapes.getGson().fromJson(data, PlayerProfileInfo.class);
                InputStream inputStream = new URL(playerProfileInfo.textures.SKIN.url).openStream();
                byte[] imageData = inputStream.readAllBytes();
                inputStream.close();
                class_2960 skinIdentifier = TextureRegistry.registerTexture(imageData);
                return new SkinTextures(skinIdentifier, playerProfileInfo.textures.SKIN.metadata != null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return SkinApi.getRandomDefaultSkin();
    }

    public static SkinTextures getRandomDefaultSkin() {
        UUID uuid = class_310.method_1551().method_1548().method_44717();
        if (uuid == null) {
            uuid = UUID.fromString("00000000-0000-0000-0000-000000000000");
        }
        class_8685 skinTextures = class_1068.method_4648((UUID)uuid);
        return new SkinTextures(skinTextures.comp_1626().comp_3627(), skinTextures.comp_1629().equals((Object)class_7920.field_41122));
    }

    public record SkinTextures(class_2960 texture, boolean slim) {
    }

    private record PlayerProfile(String id, String name, List<ProfileProperty> properties, List<String> profileActions) {

        private record ProfileProperty(String name, String value) {
        }
    }

    private record PlayerProfileInfo(long timestamp, String profileId, String profileName, Textures textures) {

        private record Textures(Texture SKIN, Texture CAPE) {
        }

        private record Texture(String url, MetaData metadata) {

            private record MetaData(String model) {
            }
        }
    }
}

