/*
 * Decompiled with CFR 0.152.
 */
package com.notium.bettercapes.screen;

import com.notium.bettercapes.BetterCapes;
import com.notium.bettercapes.api.SkinApi;
import com.notium.bettercapes.config.ConfigHandler;
import com.notium.bettercapes.data.cape.CapeCustom;
import com.notium.bettercapes.registry.TextureRegistry;
import com.notium.bettercapes.screen.CustomCapeSelectScreen;
import com.notium.bettercapes.screen.widget.capeplayer.CapePlayerRenderer;
import com.notium.bettercapes.utils.UIWrapper;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7529;

public class CreateCustomCapeScreen
extends class_437 {
    private class_7529 nameBox;
    private final class_437 parent;
    private boolean showElytra;
    private class_4185 addCapeButton;
    private CapeCustom currentCape;

    public CreateCustomCapeScreen(class_437 parent) {
        super(class_2561.method_30163((String)"Drag and drop Cape Texture!"));
        this.parent = parent;
    }

    public void method_25426() {
        this.method_37063((class_364)UIWrapper.createBackButton(10, 8, this.parent));
        int offset = (this.field_22790 - 30 - 210) / -2;
        int widthPerPlayer = (this.field_22789 - 20) / 4;
        class_7529 editBoxWidget = UIWrapper.createEditBoxWidget((int)((double)((float)this.field_22789 / 2.0f) - (double)widthPerPlayer * 1.5) + 10 - 55, this.field_22790 - 210 + offset, 110, 17, class_2561.method_30163((String)"Enter Cape Name..."), class_2561.method_30163((String)""), message -> {});
        this.nameBox = (class_7529)this.method_37063((class_364)editBoxWidget);
        this.method_37063((class_364)UIWrapper.createToggleElytraButton(this.field_22789 - 25, 8, button -> {
            this.showElytra = !this.showElytra;
        }));
        this.addCapeButton = (class_4185)this.method_37063((class_364)UIWrapper.createAddCapeButton(this.field_22789 / 2 - 40, this.field_22790 - 55, 160, 20, button -> {
            if (this.currentCape == null) {
                return;
            }
            String name = this.nameBox.method_44405();
            if (name == null || name.isEmpty()) {
                name = "Custom Cape!";
            }
            this.currentCape.name = name;
            this.currentCape.favourite = false;
            ConfigHandler.getInstance().addCapeCustomInFront(this.currentCape);
            class_437 patt0$temp = this.parent;
            if (patt0$temp instanceof CustomCapeSelectScreen) {
                CustomCapeSelectScreen customCapeSelectScreen = (CustomCapeSelectScreen)patt0$temp;
                customCapeSelectScreen.reloadAndSetScreen();
                return;
            }
            class_310.method_1551().method_1507(this.parent);
        }));
        this.method_37063((class_364)UIWrapper.createDownloadTemplateButton(this.field_22789 - 25, this.field_22790 - 25));
        this.addCapeButton.field_22763 = false;
    }

    public static void saveTemplateDataToFile() {
        Path path = FabricLoader.getInstance().getConfigDir().resolve("bettercapes/temp/");
        if (!path.toFile().exists()) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create " + String.valueOf(path), e);
            }
        }
        Path availablePath = CreateCustomCapeScreen.getAvailableFile(path.resolve("cape_template_download.png"));
        String capeTemplateBase64 = "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";
        byte[] data = Base64.getDecoder().decode(capeTemplateBase64);
        try {
            Files.write(availablePath, data, new OpenOption[0]);
        }
        catch (IOException e) {
            BetterCapes.getLogger().error("Failed to save cape template to: {}", (Object)availablePath.toString(), (Object)e);
        }
        class_156.method_668().method_672(path.toFile());
    }

    private static Path getAvailableFile(Path basePath) {
        Path newPath;
        if (!Files.exists(basePath, new LinkOption[0])) {
            return basePath;
        }
        String filename = basePath.getFileName().toString();
        Path directory = basePath.getParent();
        if (directory == null) {
            directory = Paths.get(".", new String[0]);
        }
        String name = filename;
        String extension = "";
        int dotIndex = filename.lastIndexOf(".");
        if (dotIndex != -1) {
            name = filename.substring(0, dotIndex);
            extension = filename.substring(dotIndex);
        }
        int counter = 1;
        do {
            String newFilename = name + "(" + counter + ")" + extension;
            newPath = directory.resolve(newFilename);
            ++counter;
        } while (Files.exists(newPath, new LinkOption[0]));
        return newPath;
    }

    public void method_25419() {
        class_310.method_1551().method_1507(this.parent);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, class_2561.method_30163((String)"Drag and drop Cape Texture!"), this.field_22789 / 2 + 40, this.field_22790 / 2, -1);
        context.method_27534(this.field_22793, class_2561.method_30163((String)"Download Cape Template here:"), this.field_22789 - 105, this.field_22790 - 20, -8355712);
        int offset = (this.field_22790 - 30 - 210) / -2;
        int widthPerPlayer = (this.field_22789 - 20) / 4;
        CapePlayerRenderer.drawPreview(context, (int)((double)((float)this.field_22789 / 2.0f) - (double)widthPerPlayer * 1.5) + 10, this.field_22790 - 38 + offset, 75, mouseX, mouseY, SkinApi.getPlayerSkin().texture(), SkinApi.getPlayerSkin().slim(), this.currentCape == null ? TextureRegistry.unknownCape : this.currentCape.getCapeTexture(), this.showElytra);
    }

    public void method_25410(class_310 client, int width, int height) {
        String name = this.nameBox.method_44405();
        CapeCustom cape = this.currentCape;
        boolean buttonActive = this.addCapeButton.field_22763;
        this.method_25423(client, width, height);
        this.addCapeButton.field_22763 = buttonActive;
        this.currentCape = cape;
        this.nameBox.method_44400(name);
    }

    public void method_29638(List<Path> paths) {
        byte[] data;
        File file = paths.get(0).toFile();
        if (!file.exists()) {
            BetterCapes.showInfoToast("Select a file!", null);
            return;
        }
        String fileName = file.getName().toLowerCase(Locale.ROOT);
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
        if (extension.equals("gif")) {
            BetterCapes.showInfoToast("Animated capes from gif files are not supported yet!", "This feature is planned for a future update :)");
        }
        try {
            data = Files.readAllBytes(paths.get(0));
        }
        catch (IOException e) {
            BetterCapes.showInfoToast("Failed to read image file! " + e.getMessage(), null);
            return;
        }
        if (data.length > 0x200000) {
            BetterCapes.showInfoToast("Image exceeds 2MB limit!", null);
            return;
        }
        byte[] pngData = this.loadImageAsPng(file);
        if (pngData == null) {
            BetterCapes.showInfoToast("Invalid or unsupported image format!", null);
            return;
        }
        this.currentCape = new CapeCustom(Base64.getEncoder().encodeToString(pngData), UUID.randomUUID());
        this.addCapeButton.field_22763 = true;
    }

    public byte[] loadImageAsPng(File file) {
        try {
            BufferedImage image = ImageIO.read(file);
            if (image == null) {
                BetterCapes.getLogger().error("Unsupported image format or corrupt file.");
                return null;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", baos);
            return baos.toByteArray();
        }
        catch (IOException e) {
            BetterCapes.getLogger().error("Error reading or converting image: {}", (Object)e.getMessage());
            return null;
        }
    }
}

