/*
 * Decompiled with CFR 0.152.
 */
package com.notium.bettercapes.config;

import com.notium.bettercapes.BetterCapes;
import com.notium.bettercapes.data.cape.Cape;
import com.notium.bettercapes.data.cape.CapeCustom;
import com.notium.bettercapes.registry.TextureRegistry;
import com.notium.bettercapes.websocket.ConnectionHandler;
import com.notium.bettercapes.websocket.packet.s2c.OutdatedClientS2CPacket;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigHandler {
    private static final ConfigHandler CONFIG_HANDLER = new ConfigHandler();
    private final Path DATA_DIR = FabricLoader.getInstance().getConfigDir().resolve("bettercapes");
    private final File configFile = this.DATA_DIR.resolve("config.json").toFile();
    private ConfigData configData = this.getDefaultConfig();
    private Cape cape;
    private List<CapeCustom> capeCustomList;
    private static final HashMap<ConfigEntryType, Class<?>> entryTypeToClassMap = new HashMap();

    public static ConfigHandler getInstance() {
        return CONFIG_HANDLER;
    }

    public void addCapeFromOtherInstance(CapeCustom cape) {
        if (this.capeCustomList == null) {
            return;
        }
        for (CapeCustom capeCustom : this.capeCustomList) {
            if (!capeCustom.capeUUID.equals(cape.capeUUID)) continue;
            this.putCapeCustomInFront(capeCustom);
            return;
        }
        this.addCapeCustomInFront(cape);
    }

    public static void sortCustomCapes(List<CapeCustom> list) {
        list.sort(Comparator.comparing(data -> !data.favourite));
    }

    private List<CapeCustom> getCapeCustomList() {
        if (this.capeCustomList == null) {
            this.capeCustomList = new ArrayList<CapeCustom>(Arrays.asList(this.getEntry(ConfigEntryType.CUSTOM_CAPE_DATA, CapeCustom[].class)));
        }
        ConfigHandler.sortCustomCapes(this.capeCustomList);
        return this.capeCustomList;
    }

    public CapeCustom[] getCapeCustom() {
        return this.getCapeCustomList().toArray(new CapeCustom[0]);
    }

    public void updateCapeCustomChangeToFile() {
        this.setEntry(ConfigEntryType.CUSTOM_CAPE_DATA, BetterCapes.getGson().toJson(this.getCapeCustomList()));
    }

    public void deleteCustomCape(CapeCustom capeCustom) {
        this.getCapeCustomList().remove(capeCustom);
        this.setEntry(ConfigEntryType.CUSTOM_CAPE_DATA, BetterCapes.getGson().toJson(this.getCapeCustomList()));
    }

    public void addCapeCustomInFront(CapeCustom capeCustom) {
        this.getCapeCustomList().add(0, capeCustom);
        ConfigHandler.sortCustomCapes(this.getCapeCustomList());
        this.setEntry(ConfigEntryType.CUSTOM_CAPE_DATA, BetterCapes.getGson().toJson(this.getCapeCustomList()));
    }

    public void putCapeCustomInFront(CapeCustom capeCustom) {
        List<CapeCustom> capeCustomList = this.getCapeCustomList();
        capeCustomList.remove(capeCustom);
        capeCustomList.add(0, capeCustom);
        this.setEntry(ConfigEntryType.CUSTOM_CAPE_DATA, BetterCapes.getGson().toJson((Object)capeCustomList.toArray()));
    }

    public ConfigData getDefaultConfig() {
        HashMap<ConfigEntryType, String> config = new HashMap<ConfigEntryType, String>();
        config.put(ConfigEntryType.CAPE, "{\"type\":\"DEFAULT\"}");
        config.put(ConfigEntryType.SHOW_BADGE_IN_TABLIST, "false");
        config.put(ConfigEntryType.SHOW_BADGE_ON_NAMETAG, "false");
        config.put(ConfigEntryType.SELECT_SCREEN_BUTTON_POSITION, ButtonPositioning.LEFT.name());
        config.put(ConfigEntryType.BADGE_RENDER_POSITION, BadgeRenderPosition.AFTER.name());
        config.put(ConfigEntryType.ALIGN_PLAYER_NAMES, "false");
        config.put(ConfigEntryType.OUTDATED_CLIENT, "false");
        config.put(ConfigEntryType.CUSTOM_CAPE_DATA, "[]");
        config.put(ConfigEntryType.OUTDATED_CLIENT_DATA, "{}");
        return new ConfigData("1.2", config);
    }

    private void ensureDataDir() {
        if (!this.DATA_DIR.toFile().exists()) {
            try {
                Files.createDirectories(this.DATA_DIR, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create " + String.valueOf(this.DATA_DIR), e);
            }
        }
    }

    public Cape getCustomCape() {
        if (!this.getCapeCustomList().isEmpty()) {
            return this.getCapeCustomList().get(0);
        }
        return new Cape(TextureRegistry.unknownCape);
    }

    public Cape getPlayerCape() {
        return this.cape;
    }

    public <T> T getEntry(ConfigEntryType entryType, Class<T> type) {
        Class<T> entryClass = entryTypeToClassMap.get((Object)entryType);
        if (entryClass == null) {
            throw new IllegalArgumentException("No class mapping found for entry type: " + String.valueOf((Object)entryType));
        }
        if (!entryClass.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Provided class does not match the expected type.");
        }
        String data = this.configData.config.get((Object)entryType);
        if (data == null) {
            data = this.getDefaultConfig().config.get((Object)entryType);
        }
        return (T)BetterCapes.getGson().fromJson(data, type);
    }

    public void setEntry(ConfigEntryType entry, String value) {
        this.configData.config.put(entry, value);
        this.saveConfig();
    }

    public void loadConfig() {
        this.ensureDataDir();
        if (!this.configFile.exists()) {
            this.configData = this.getDefaultConfig();
            this.saveConfig();
        }
        try {
            this.configData = (ConfigData)BetterCapes.getGson().fromJson(Files.readString(this.configFile.toPath()), ConfigData.class);
        }
        catch (Exception e) {
            BetterCapes.getLogger().error("Failed to load config from file: {}", (Object)e.getMessage());
        }
        if (this.configData == null || !Objects.equals(this.configData.version, this.getDefaultConfig().version)) {
            this.configData = this.getDefaultConfig();
            this.saveConfig();
        }
        this.cape = this.getEntry(ConfigEntryType.CAPE, Cape.class);
        ConnectionHandler.getInstance().start();
    }

    public void refreshCapeIdentifier() {
        this.cape.removeCapeTexture();
    }

    public void setPlayerCape(Cape cape, boolean changedByThisInstance) {
        this.configData.config.put(ConfigEntryType.CAPE, BetterCapes.getGson().toJson((Object)cape));
        this.cape = cape;
        this.saveConfig();
        ConnectionHandler.getInstance().updatePlayerCapeData(cape, changedByThisInstance);
    }

    public void saveConfig() {
        try {
            Files.writeString(this.configFile.toPath(), (CharSequence)BetterCapes.getGson().toJson((Object)this.configData), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <E extends Enum<E>> String formatEnumValue(E value) {
        String name = value.name().replace("_", " ");
        return name.charAt(0) + name.substring(1).toLowerCase();
    }

    private static <E extends Enum<E>> E nextEnumValue(E current, Class<E> enumType) {
        Enum[] values = (Enum[])enumType.getEnumConstants();
        int currentIndex = current.ordinal();
        int nextIndex = (currentIndex + 1) % values.length;
        return (E)values[nextIndex];
    }

    public <E extends Enum<E>> E toggleButton(E current, Class<E> enumType, ConfigEntryType entry) {
        E nextEnum = ConfigHandler.nextEnumValue(current, enumType);
        this.setEntry(entry, nextEnum.name());
        return nextEnum;
    }

    static {
        entryTypeToClassMap.put(ConfigEntryType.SHOW_BADGE_IN_TABLIST, Boolean.class);
        entryTypeToClassMap.put(ConfigEntryType.SHOW_BADGE_ON_NAMETAG, Boolean.class);
        entryTypeToClassMap.put(ConfigEntryType.BADGE_RENDER_POSITION, BadgeRenderPosition.class);
        entryTypeToClassMap.put(ConfigEntryType.ALIGN_PLAYER_NAMES, Boolean.class);
        entryTypeToClassMap.put(ConfigEntryType.SELECT_SCREEN_BUTTON_POSITION, ButtonPositioning.class);
        entryTypeToClassMap.put(ConfigEntryType.CUSTOM_CAPE_DATA, CapeCustom[].class);
        entryTypeToClassMap.put(ConfigEntryType.CAPE, Cape.class);
        entryTypeToClassMap.put(ConfigEntryType.OUTDATED_CLIENT, Boolean.class);
        entryTypeToClassMap.put(ConfigEntryType.OUTDATED_CLIENT_DATA, OutdatedClientS2CPacket.class);
    }

    public record ConfigData(String version, HashMap<ConfigEntryType, String> config) {
    }

    public static enum ConfigEntryType {
        CAPE,
        SHOW_BADGE_IN_TABLIST,
        SHOW_BADGE_ON_NAMETAG,
        SELECT_SCREEN_BUTTON_POSITION,
        BADGE_RENDER_POSITION,
        ALIGN_PLAYER_NAMES,
        CUSTOM_CAPE_DATA,
        OUTDATED_CLIENT,
        OUTDATED_CLIENT_DATA;

    }

    public static enum ButtonPositioning {
        LEFT,
        RIGHT;

    }

    public static enum BadgeRenderPosition {
        BEFORE,
        AFTER;

    }
}

