/*
 * Decompiled with CFR 0.152.
 */
package com.notium.bettercapes.data;

import com.notium.bettercapes.data.cape.Cape;
import com.notium.bettercapes.data.cape.CapeDefault;
import com.notium.bettercapes.websocket.ConnectionHandler;
import com.notium.bettercapes.websocket.packet.c2s.RequestPlayerDataC2SPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class PlayerCapeDataHandler {
    private static final PlayerCapeDataHandler PLAYER_CAPE_DATA_HANDLER = new PlayerCapeDataHandler();
    private final CopyOnWriteArrayList<UUID> dataRequests = new CopyOnWriteArrayList();
    public ConcurrentHashMap<UUID, Cape> playerCapeDataHashMap = new ConcurrentHashMap();

    public static PlayerCapeDataHandler getInstance() {
        return PLAYER_CAPE_DATA_HANDLER;
    }

    public PlayerCapeDataHandler() {
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> {
            if (!this.dataRequests.isEmpty()) {
                List requests = this.dataRequests.stream().toList();
                this.dataRequests.clear();
                int chunkSize = 50;
                for (int i = 0; i < requests.size(); i += chunkSize) {
                    int endIndex = Math.min(i + chunkSize, requests.size());
                    List chunk = requests.subList(i, endIndex);
                    ConnectionHandler.getInstance().sendC2SPacket(new RequestPlayerDataC2SPacket(chunk.toArray(new UUID[0])));
                }
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    public void removePlayers(List<UUID> excludedPlayers) {
        ArrayList<UUID> keysToRemove = new ArrayList<UUID>();
        for (UUID key : this.playerCapeDataHashMap.keySet()) {
            if (excludedPlayers.contains(key)) continue;
            keysToRemove.add(key);
        }
        for (UUID key : keysToRemove) {
            Cape cape = this.playerCapeDataHashMap.remove(key);
            if (cape == null) continue;
            cape.removeCapeTexture();
        }
    }

    public void resetData() {
        for (Cape cape : this.playerCapeDataHashMap.values()) {
            if (cape == null) continue;
            cape.removeCapeTexture();
        }
        this.playerCapeDataHashMap.clear();
        this.dataRequests.clear();
    }

    public Cape getPlayerCape(UUID uuid) {
        if (!this.playerCapeDataHashMap.containsKey(uuid)) {
            this.playerCapeDataHashMap.put(uuid, new CapeDefault());
            if (!this.dataRequests.contains(uuid)) {
                this.dataRequests.add(uuid);
            }
        }
        return this.playerCapeDataHashMap.get(uuid);
    }

    public boolean containsPlayer(UUID uuid) {
        return this.playerCapeDataHashMap.containsKey(uuid);
    }

    public void setPlayerCape(UUID uuid, Cape cape) {
        this.playerCapeDataHashMap.put(uuid, cape);
        this.dataRequests.remove(uuid);
    }
}

