/*
 * Decompiled with CFR 0.152.
 */
package com.notium.bettercapes.websocket;

import com.notium.bettercapes.BetterCapes;
import com.notium.bettercapes.data.BuiltinCapesHandler;
import com.notium.bettercapes.data.PlayerCapeDataHandler;
import com.notium.bettercapes.data.TabListDataHandler;
import com.notium.bettercapes.data.cape.Cape;
import com.notium.bettercapes.screen.FeedbackScreen;
import com.notium.bettercapes.websocket.packet.c2s.C2SPacket;
import com.notium.bettercapes.websocket.packet.c2s.RequestBuiltinCapesC2SPacket;
import com.notium.bettercapes.websocket.packet.c2s.SetCapeC2SPacket;
import com.notium.bettercapes.websocket.packet.c2s.authentication.RequestAuthenticationServerIdC2SPacket;
import com.notium.bettercapes.websocket.packet.s2c.S2CPacket;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_310;
import org.eclipse.jetty.websocket.api.Callback;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketOpen;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.client.WebSocketClient;

public class ConnectionHandler {
    public static final ConnectionHandler INSTANCE = new ConnectionHandler();
    private static final URI SERVER_URI = URI.create("wss://bettercapes.net:8443/minecraft/bettercapes");
    private static final long RETRY_DELAY_MS = 5000L;
    public boolean updateReconnect = false;
    private WebSocketClient client;
    private volatile Session session;

    private void showNoConnectionMessage(C2SPacket c2SPacket) {
        switch (c2SPacket.type) {
            case SEND_FEEDBACK_C2S_PACKET: {
                BetterCapes.showInfoToast("Failed to send feedback!", "No connection to Better Capes server!");
                this.updateReconnect = true;
                FeedbackScreen.setSendingFalse();
                break;
            }
            case SET_CAPE_C2S_PACKET: {
                BetterCapes.showInfoToast("Failed to upload cape!", "No connection to Better Capes server!");
                this.updateReconnect = true;
            }
        }
    }

    public void updatePlayerCapeData(Cape cape, boolean changedByThisInstance) {
        if (cape != null) {
            this.sendC2SPacket(new SetCapeC2SPacket(cape, changedByThisInstance));
        }
    }

    public void sendC2SPacket(C2SPacket c2SPacket) {
        if (c2SPacket == null) {
            return;
        }
        if (!this.isConnected()) {
            this.showNoConnectionMessage(c2SPacket);
            return;
        }
        byte[] data = BetterCapes.getGson().toJson((Object)c2SPacket).getBytes();
        if (data.length > 150000000) {
            return;
        }
        this.session.sendBinary(ByteBuffer.wrap(data), Callback.NOOP);
    }

    public void start() {
        this.client = new WebSocketClient();
        this.client.setIdleTimeout(Duration.ofMinutes(5L));
        this.client.setMaxBinaryMessageSize(0x100000L);
        try {
            this.client.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start WebSocket client", e);
        }
        Thread connectThread = new Thread(this::connectLoop, "WebSocket-Reconnect-Thread");
        connectThread.setDaemon(true);
        connectThread.start();
    }

    public static ConnectionHandler getInstance() {
        return INSTANCE;
    }

    public boolean isConnected() {
        return this.session != null && this.session.isOpen();
    }

    private void connectLoop() {
        while (true) {
            try {
                if (this.session == null || !this.session.isOpen()) {
                    ClientSocket socket = new ClientSocket();
                    this.session = this.client.connect(socket, SERVER_URI).get(5L, TimeUnit.MINUTES);
                    BetterCapes.getLogger().info("Connected to Better Capes server!");
                }
            }
            catch (Exception socket) {
                // empty catch block
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    @WebSocket
    public class ClientSocket {
        @OnWebSocketOpen
        public void onOpen(Session sess) {
            ConnectionHandler.this.session = sess;
            if (ConnectionHandler.this.updateReconnect) {
                BetterCapes.showInfoToast("Reconnected to Better Capes server!", null);
                ConnectionHandler.this.updateReconnect = false;
            }
            PlayerCapeDataHandler.getInstance().resetData();
            TabListDataHandler.getInstance().resetData();
            ConnectionHandler.this.sendC2SPacket(new RequestAuthenticationServerIdC2SPacket());
            ConnectionHandler.this.sendC2SPacket(new RequestBuiltinCapesC2SPacket(BuiltinCapesHandler.getInstance().getLoadedCapesHash()));
        }

        @OnWebSocketMessage
        public void onWebSocketByte(InputStream stream) {
            String json;
            try {
                json = new String(stream.readAllBytes());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            S2CPacket s2CPacket = (S2CPacket)BetterCapes.getGson().fromJson(json, S2CPacket.class);
            if (s2CPacket == null) {
                return;
            }
            class_310.method_1551().execute(s2CPacket::handleResponse);
        }

        @OnWebSocketError
        public void onError(Throwable cause) {
            BetterCapes.getLogger().error("Better Capes connection error: {}", (Object)cause.getMessage());
        }

        @OnWebSocketClose
        public void onClose(int statusCode, String reason) {
            BetterCapes.getLogger().info("Lost connection to Better Capes server: {} / {}", (Object)statusCode, (Object)reason);
            if (class_310.method_1551().field_1755 instanceof FeedbackScreen) {
                BetterCapes.showInfoToast("Lost connection to Better Capes server!", "You will not be able to send your feedback :/");
            }
            ConnectionHandler.this.session = null;
        }
    }
}

