/*
 * Decompiled with CFR 0.152.
 */
package com.notium.bettercapes.data;

import com.notium.bettercapes.BetterCapes;
import com.notium.bettercapes.config.ConfigHandler;
import com.notium.bettercapes.data.PlayerCapeDataHandler;
import com.notium.bettercapes.data.cape.Cape;
import com.notium.bettercapes.data.cape.CapeBuiltin;
import com.notium.bettercapes.registry.TextureRegistry;
import com.notium.bettercapes.screen.CapeSelectScreen;
import com.notium.bettercapes.websocket.ConnectionHandler;
import com.notium.bettercapes.websocket.packet.c2s.RequestBuiltinCapesC2SPacket;
import com.notium.bettercapes.websocket.packet.s2c.BuiltinCapesS2CPacket;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class BuiltinCapesHandler {
    private boolean finishedLoading = false;
    private static final BuiltinCapesHandler BUILTIN_CAPES_HANDLER = new BuiltinCapesHandler();
    private final Path DATA_DIR = FabricLoader.getInstance().getConfigDir().resolve("bettercapes");
    private final File capesFile = this.DATA_DIR.resolve("capes.json").toFile();
    private CapeData[] capes = null;
    private String loadedCapesHash = "";
    private static HashMap<Integer, class_2960> capeTextures = new HashMap();
    private BuiltinCapesS2CPacket.BuiltinCape[] preloadedCapes;

    public boolean isFinishedLoading() {
        return this.finishedLoading;
    }

    public String getLoadedCapesHash() {
        return this.loadedCapesHash;
    }

    public void loadPreloadedCapes() {
        this.preloadedCapes = new BuiltinCapesS2CPacket.BuiltinCape[]{new BuiltinCapesS2CPacket.BuiltinCape("Microsoft Cape", "iVBORw0KGgoAAAANSUhEUgAAAEAAAAAgCAYAAACinX6EAAACiElEQVR4XuWWT2oVQRjE3xGCCDG4MFF0EzSIGFBBEZTss8km4M6NJ/AE7gR3HsO1kHU2LvUIHsATjKlmaqjU149umh5BevHj9avpmf6q+ps/m1enPzZnr3cmsH9wmIXHP9y4NX3Zuz99v3OUBcfmOZtfD55V8eTp2+nw4Yt0/tX/HOEcME1TFzZq0o3XHNuGF7wNBuB6CTfSyhLAp/e7qRCAolgYwDE3WMILLsF18fvm5Dyha/t8N9JK2gEWffF5PwQAjcd1bgkvuASvr0DT8FcLgIuh1dUwxmx/naegwFyHuMEaNHyupfXoreJGWkmL0sjHm7cTP789TvA/DXKumsdDD3gIbq4GnKfdB1DHqgEwZRj9und3MU2o6U64+VwIbq4GmsyZXy0ANU/4WlONIbDl3TxgtwA3V0MuAO0+0jUAFK1m9X3sOubSKMceAHU3VwON4tdvQT6guwegOw4u7x1fC0DBXDeaCwC4uRrY6t6VvCZ00D0AmNYAfj86SriuxeCrz0OARt3N1cCdVvPalRquG2llCYBmsRADwJjmNQAa5acvd1/1+VrBZAma59qsiVBzI61cC4DtzwDYBdAYkJrkbrt5MBccDFYQnkVO1wB0h9n+f14+T7ALAMb/IgCuo3B9rceNtJIC4IURAM0TLoixB0DzPQPgmtoBuVvBjbSSAuCiLQFsewbM5wWDJTQArWO1DsD9VhsA5qpJfw12CmAJget6ENDdSCtB6MVsIBgsoQFoEKt1gAu9mAsNBksggOnd+RIAxmSYDrgyu4SgATCEIQLA+blb4L/pgPm1FQyWkA5YQvDd7/oh5MJoBGE0gjAaQRiNIIxGEEYjCKMRhNEIwmgEYTT+AksiJ9gdoefNAAAAAElFTkSuQmCC", 0, 0), new BuiltinCapesS2CPacket.BuiltinCape("Vanilla Cape", "iVBORw0KGgoAAAANSUhEUgAAAEAAAAAgCAYAAACinX6EAAACL0lEQVR4Xu1XO07DQBTMWUKdKhJICIkGRYBpEgnlAJaoTI2go0C5QdxQUVBzAi4AdzKMpbGen3a9L+tNmuxIT+vPvH07s2uvPblc/U6WL2fN08dd8/ZdNK9fy94xWpyDM5/Pm+l02gXP0RZF0ZRl2R5PjJB9+ULnJAeEPXxe9ASjleJxTJ6Vq+v4cDChPqxOT5ptdesUxpWAe+A935+bubpOCDBtKDQ/GWjA482sE4Z4/6laYbgG4dIAC1fXCcG3Emns3kygAZvNphPGAeAY16qq6hlg4eo6FiAvtbFB0AAUQEAEClMQQxpg4eo6FiBvH8YOAp2WV7NOlFzmWhR4Vq6uYwFNTm3sILiVQRiWtksUCsst0MLVdSygAa5+2XfyHQODvV4s2kFzdlmcy457PXhWrq5jAfJDxiY3gKIYEMbiKIprdV33OBaurmMB3vQhY2P79oJi1ut1TxgFIeTsW7m6jgXc84eMje3bC4hBoABafs62z/r/Me/LsHBjl6o0wWUsJ0DnRUMOXArikuN9LTDEHWMAP6ddxnICdF405KApiC1+cBAo6DPKxx1jALY/+dy7JkHnRYMDRiEGZ5XXpTArd4wBeAnSAG0sjdB50ZBCpCCeU5QWHeLGGgDh8s2vjeW5zouGFCXFsJX/+btwYw0AIF4+AtJYtGP6PhjGDFIbII09GgPkypJxFAYAyOf+f9QGyA8hroqxfR8EKQZJsa7Q3IyMjIyMjIyMjIzd8Ac4aFXpp4FetQAAAABJRU5ErkJggg==", 1, 1), new BuiltinCapesS2CPacket.BuiltinCape("Cherry Blossom", "iVBORw0KGgoAAAANSUhEUgAAAEAAAAAgBAMAAABQs2O3AAAAElBMVEUAAAD/8f/+z/n/s+z/lNb7bMS8quC2AAAAAXRSTlMAQObYZgAAAPRJREFUeNrtj0FywjAQBFUE32OTB9gjfcC7m3vIjj9ASf//SgpsjEwBOeSauWmq1RqFppRSTgDQhxBCUwANdfIZ4FRKyZdzCXfBdPrMSCWW77k4X9gAyRMBCivgqwYOJHUg6XPRlGnKNWCkt8nJcQFyzqwBOkWTmcergZQKUJo5zNe2yXTvtwYikdeRTTbT/m4DIlfD3l1rQA+ktKPRh7l4M9Unhve5iaoy3oCWJPFx3tCvgHYbw/FiMFmBKNU/I60zpHiMN4MA1RPxENF2I7rhZqgBQLBkAXYigvAoK7AxPAIwvASCouteApBfDDs82fCfv+QHRgc7p+s8lMMAAAAASUVORK5CYII=", 2, 2), new BuiltinCapesS2CPacket.BuiltinCape("Minecon 2011 Cape", "iVBORw0KGgoAAAANSUhEUgAAAEAAAAAgCAYAAACinX6EAAAAAXNSR0IArs4c6QAAAAZiS0dEAP8A/wD/oL2nkwAAAAlwSFlzAAAOwwAADsMBx2+oZAAAAAd0SU1FB98KBgk2H0ui5CgAAAMpSURBVGje7Zg/axtJGIef2VkFicQg7lhisiyoUZdKJqS5Kw3XOfgjpE3hFMkXSJsmKdznI9hpElB5RRLCqbsmgkOwkROzJBhikNDO7qRYz2il+I8k7/oC2QeEFlbMzPub3zvvOxIAz6+5upekHGrNadwUgo50eDJRLMIXECzIP43azKQff0sBGETZEDsTtfBYq+D+5QgNsL0uGEQOvSS1LzvSAaDlaQYR3HEE/50hUp7fQX/QLLXwjVGc/X7IleICWdCRQ8vT/PFVMr8jg0jMCFMkJvB5J8y7oSwnuAAemlcqgU8AKTfFdK7DT9m6bgs4vIIdMUHnaXmafaTeGiaFi+AABFLOBn1icw/NbcHMu7KwKQC0gwbtoGF3fxAJ/v6c8kgKXYoABhOsOfQCKQlklhLm+zT8gnf/6JuyQrQ8bec/bw2XSgFDICVRkuKh+T+JjmIAmmsu7aCB18xVn39VOQ7YXhfsxoo36TQHd2PFbqzYXhdXErgpfUYE44Tmmms/+77UhQsQJonNOT9ndz+XkxdRVBp4zdqpInR7Y7q9MaWdAd3emL27N9hwhN35DUewd/fGmRP7JbiguebiNWtWiOgoptsbEybJwpux9BkQISBJ6PbGvEynDnuZav4MR4Ql9QDniWB431eESUIgJZudenkOMPXW7Kx/Sbs/v+Yunas7EyXybnvfz+x//851Njt1+uGIfjhaaewLq0CW9xofeHhL0g4aPHh3bN8ZC15FGvTDEYMoS0UArCiiPAe0PE07aHCvNrVf/nkRihIjn+f+XEXai5V1aqGtsFHXWM08Z+VpvHSwm506vD1eekEmuM1OndbJOh4fKDvnvZpLO6jD8LhYB5x3uhap+KJ0e+OZvmA+RQq/C1zEom2onwtgFbaGiT0Id2PFs4OEByepOAT2YnWmMCulwOtUi9cT9aNdz7HYh8XGvpRtWp6Gg+nfA09vyR+6xcLvAj8L5kB+0VQn9wJtgz+rGhXSBxQdxKpsDRPRD0e2K8yPWfStsDQBLtuyGqvPt8YtTxdfBn9GdiZK7IcjPYiELcf5FrmoMlhRUVFRUVFRUfGr8h1KVExpP3QPdAAAAABJRU5ErkJggg==", 3, 3), new BuiltinCapesS2CPacket.BuiltinCape("Minecon 2012 Cape", "iVBORw0KGgoAAAANSUhEUgAAAEAAAAAgCAMAAACVQ462AAAALVBMVEX////////5uxW2gBpsWDQBI0QBHTkBFisBDhwBMmEBNmkBR4kBXrEBbc0Oju8YWXkWAAAAAXRSTlMAQObYZgAAAQlJREFUeF7t0MFuwyAURFHCA9phGP7/c8uzZatxwYqy6iJXiBU6GhEeRN4Cv88e4UziVliVKQIgxfx19hsI92VQbSRiCjgh+ZMVUH0+kHNdAq2PVkImXKgVKyCo32xwoMISCe5A+QO0LrJJS8DiyG4ANQJNWgAWLaVx3S4AuJiQa0zVklI8gHIF2NcTHAAZTawbUGaApAawzQFUB7pqXQMUAZILQCdQDoDPAohoADQFuAPcgTIFLHrkFFDXE+ACngGLsAQzzICq3sfpG1DmAIFoIOZA3wHdAXRAnAI8AJ5AufxB2AGK4dUuABwgqXcBNjUAfH0BLuAAXHgfoNQI4G0gNDYXwj/t06cfITMTf9021iwAAAAASUVORK5CYII=", 4, 4), new BuiltinCapesS2CPacket.BuiltinCape("Minecon 2013 Cape", "iVBORw0KGgoAAAANSUhEUgAAAEAAAAAgCAMAAACVQ462AAAAZlBMVEUAAAAYOCImWDUxcEQ5hFAhTC4lVzUULxxEREQTExMdRSkrKytgYGBLOyJAk1lKqmbNzc3Ozs7v7++0kFqtg0qJaj+8jlJnUCpCmFv///8PIhSDZDKaeUoKFw51WjIiTzAsZz6Sbz/CA4vkAAAAAXRSTlMAQObYZgAAAStJREFUeNqc0gduwzAMhWE/DnnP7O7e/5Il0dpoXdMI8ivEDD5QSujGCnjKr0u3bOl6JY+yKLCwqjIL42npN5DtB2W5WsZsAU54IhIBBEBVAQoB6axIAKsLRBoAJnS9JYEAHs/n0Ye/gfwfIF1PJEYEQNO2jU8M9EKACQFgtS1bexsAFKwAYuaLATQD+Rrgbm8FKDE9X4SJHMi3AL8/QBIAdVHXhc0OkD5SBaQUAE3R2MeBfAbor4BpPBymsZJgAxdmIN8CqulkDaAAcKFYABewAg4vfoAtgMqytsrSgXwbSG8nPwHgb9zb7AHT+fN4HKpNgPsfgA2YhdVl0zjYEwyJsntbffPdf0ZUSR4F/L8IgOhuYH1ZA1x4HGB/ZAAPA5mwuJB9bZCCUTAKABS3GxzekX55AAAAAElFTkSuQmCC", 5, 5), new BuiltinCapesS2CPacket.BuiltinCape("Minecon 2015 Cape", "iVBORw0KGgoAAAANSUhEUgAAAEAAAAAgCAMAAACVQ462AAAARVBMVEUBAAAFIR0BGhYNKiYTMi0gQDwnSEQ0VlE5W1ZHaWRVd3JihH+DcWidj4etoZrAoYnHrZnYv63dybnU1NRZRDaJEy8AAACCKtX2AAAAAXRSTlMAQObYZgAAAQ5JREFUeNqU0+UBFjAMhsFLijv7r4j8QT5rXxYIdgM81ZQXO6DWDcAB4JVHVOpm9uSJJ9ksld4AFQDcAOaAveopkm3ywyuIXMyBelBEh9lGPBu30hRRXTDvobsleTbvwNuC5DvQBwAg6kXB5zHQW0H6mCG1hTFgBbQZTldK+fh1CpwGMJ9BaDOadJ9Hd0D7Ty2JHTnHDE53O/cxQE7OCTTAMwC4FIH1YbxEd3LXQBscUmxjIMvdyoH5FhHxkClQl067ONCABQAqewNTQKtdqgBgAwAWqfu8g4ZCH+Yz/Hz5HeZZeDwAsM3SjpMxYLQAAKcdV4P2Ly59mLXRHl7x1/AaQNgJTEzgmBqkYBSMAgD/5XnnDgHWOQAAAABJRU5ErkJggg==", 6, 6)};
    }

    private void ensureDataDir() {
        if (!this.DATA_DIR.toFile().exists()) {
            try {
                Files.createDirectories(this.DATA_DIR, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create " + String.valueOf(this.DATA_DIR), e);
            }
        }
    }

    public static BuiltinCapesHandler getInstance() {
        return BUILTIN_CAPES_HANDLER;
    }

    public void loadCapes() {
        if (this.capes != null) {
            return;
        }
        if (this.preloadedCapes == null) {
            this.loadPreloadedCapes();
        }
        BuiltinCapesS2CPacket.BuiltinCape[] capes = null;
        this.ensureDataDir();
        if (this.capesFile.exists()) {
            try {
                String json = Files.readString(this.capesFile.toPath());
                CapeFile capeFile = (CapeFile)BetterCapes.getGson().fromJson(json, CapeFile.class);
                if (capeFile != null) {
                    capes = capeFile.capes;
                }
            }
            catch (IOException e) {
                BetterCapes.getLogger().error("Failed to load capes", (Throwable)e);
            }
        }
        if (capes == null) {
            capes = this.preloadedCapes;
        }
        this.loadBuiltinCapes(capes);
        this.finishedLoading = true;
        ConnectionHandler.getInstance().sendC2SPacket(new RequestBuiltinCapesC2SPacket(this.getLoadedCapesHash()));
    }

    public class_2960 getCapeTextureById(int capeId) {
        return capeTextures.get(capeId);
    }

    public CapeData[] getLoadedCapes() {
        if (this.capes == null) {
            this.loadCapes();
            if (this.capes == null) {
                return new CapeData[0];
            }
        }
        return this.capes;
    }

    public void unloadOldTextures() {
        if (capeTextures == null) {
            return;
        }
        for (class_2960 identifier : capeTextures.values()) {
            TextureRegistry.unloadCape(identifier);
        }
        capeTextures = new HashMap();
    }

    public void loadBuiltinCapes(BuiltinCapesS2CPacket.BuiltinCape[] builtinCapes) {
        try {
            this.unloadOldTextures();
            this.capes = new CapeData[builtinCapes.length];
            Base64.Decoder decoder = Base64.getDecoder();
            StringBuilder names = new StringBuilder();
            capeTextures = new HashMap();
            for (int i = 0; i < builtinCapes.length; ++i) {
                class_2960 texture = TextureRegistry.registerTexture(decoder.decode(builtinCapes[i].imageDataBase64()));
                this.capes[i] = new CapeData(texture, builtinCapes[i].displayName(), builtinCapes[i].menuPosition(), builtinCapes[i].capeId());
                names.append(builtinCapes[i].displayName()).append(builtinCapes[i].menuPosition()).append(builtinCapes[i].capeId());
            }
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                this.loadedCapesHash = Base64.getEncoder().encodeToString(digest.digest(names.toString().getBytes()));
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Exception e) {
            BetterCapes.getLogger().error("Failed to load builtin capes", (Throwable)e);
        }
    }

    public void loadBuiltinCapesFromServer(BuiltinCapesS2CPacket.BuiltinCape[] builtinCapes) {
        this.ensureDataDir();
        try {
            Files.write(this.capesFile.toPath(), BetterCapes.getGson().toJson((Object)new CapeFile(builtinCapes)).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.loadBuiltinCapes(builtinCapes);
        PlayerCapeDataHandler.getInstance().resetData();
        ConfigHandler.getInstance().refreshCapeIdentifier();
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof CapeSelectScreen) {
            CapeSelectScreen capeSelectScreen = (CapeSelectScreen)class_4372;
            capeSelectScreen.reloadAndSetScreen();
        }
    }

    public static class CapeData {
        public Cape cape;
        public String capeName;
        public int menuPosition;
        public int capeId;

        public CapeData(class_2960 capeTexture, String capeName, int menuPosition, int capeId) {
            capeTextures.put(capeId, capeTexture);
            this.cape = new CapeBuiltin(capeId);
            this.capeName = capeName;
            this.menuPosition = menuPosition;
            this.capeId = capeId;
        }
    }

    private record CapeFile(BuiltinCapesS2CPacket.BuiltinCape[] capes) {
    }
}

