/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.URI;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Graceful;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ShutdownThread;
import org.eclipse.jetty.websocket.api.Configurable;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketContainer;
import org.eclipse.jetty.websocket.api.WebSocketSessionListener;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.JettyUpgradeListener;
import org.eclipse.jetty.websocket.client.internal.JettyClientUpgradeRequest;
import org.eclipse.jetty.websocket.common.JettyWebSocketFrameHandler;
import org.eclipse.jetty.websocket.common.JettyWebSocketFrameHandlerFactory;
import org.eclipse.jetty.websocket.common.SessionTracker;
import org.eclipse.jetty.websocket.core.Configuration;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.client.UpgradeListener;
import org.eclipse.jetty.websocket.core.client.WebSocketCoreClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketClient
extends ContainerLifeCycle
implements Configurable,
WebSocketContainer,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketClient.class);
    private final WebSocketCoreClient coreClient;
    private final int id = ThreadLocalRandom.current().nextInt();
    private final JettyWebSocketFrameHandlerFactory frameHandlerFactory;
    private final List<WebSocketSessionListener> sessionListeners = new CopyOnWriteArrayList<WebSocketSessionListener>();
    private final SessionTracker sessionTracker = new SessionTracker();
    private final Configuration.ConfigurationCustomizer configurationCustomizer = new Configuration.ConfigurationCustomizer();
    private boolean stopAtShutdown = false;
    private long _stopTimeout = Long.MAX_VALUE;

    public WebSocketClient() {
        this(null);
    }

    public WebSocketClient(HttpClient httpClient) {
        this.coreClient = new WebSocketCoreClient(httpClient, null);
        this.addManaged(this.coreClient);
        this.frameHandlerFactory = new JettyWebSocketFrameHandlerFactory(this, this.coreClient.getWebSocketComponents());
        this.sessionListeners.add(this.sessionTracker);
        this.installBean(this.sessionTracker);
    }

    public CompletableFuture<Session> connect(Object websocket, URI toUri) throws IOException {
        return this.connect(websocket, toUri, null);
    }

    public CompletableFuture<Session> connect(Object websocket, URI toUri, ClientUpgradeRequest request) throws IOException {
        return this.connect(websocket, toUri, request, null);
    }

    public CompletableFuture<Session> connect(Object websocket, URI toUri, ClientUpgradeRequest request, final JettyUpgradeListener upgradeListener) throws IOException {
        for (Connection.Listener listener : this.getBeans(Connection.Listener.class)) {
            this.coreClient.addBean(listener);
        }
        JettyClientUpgradeRequest upgradeRequest = new JettyClientUpgradeRequest(this.coreClient, request, toUri, this.frameHandlerFactory, websocket);
        upgradeRequest.setConfiguration(this.configurationCustomizer);
        for (Request.Listener l : this.getBeans(Request.Listener.class)) {
            upgradeRequest.listener(l);
        }
        if (upgradeListener != null) {
            upgradeRequest.addListener(new UpgradeListener(){
                final /* synthetic */ WebSocketClient this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void onHandshakeRequest(Request request) {
                    upgradeListener.onHandshakeRequest(request);
                }

                @Override
                public void onHandshakeResponse(Request request, Response response) {
                    upgradeListener.onHandshakeResponse(request, response);
                }
            });
        }
        CompletableFuture<Session> completableFuture = new CompletableFuture<Session>();
        CompletableFuture<CoreSession> coreConnect = this.coreClient.connect(upgradeRequest);
        coreConnect.whenComplete((coreSession, error) -> {
            if (error != null) {
                futureSession.completeExceptionally(JettyWebSocketFrameHandler.convertCause(error));
                return;
            }
            JettyWebSocketFrameHandler frameHandler = (JettyWebSocketFrameHandler)upgradeRequest.getFrameHandler();
            futureSession.complete(frameHandler.getSession());
        });
        completableFuture.whenComplete((session, throwable) -> {
            if (throwable != null) {
                coreConnect.completeExceptionally((Throwable)throwable);
            }
        });
        return completableFuture;
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.dumpObjects(out, indent, this.getOpenSessions());
    }

    @Override
    public void addSessionListener(WebSocketSessionListener listener) {
        this.sessionListeners.add(listener);
    }

    @Override
    public boolean removeSessionListener(WebSocketSessionListener listener) {
        return this.sessionListeners.remove(listener);
    }

    @Override
    public void notifySessionListeners(Consumer<WebSocketSessionListener> consumer) {
        for (WebSocketSessionListener listener : this.sessionListeners) {
            try {
                consumer.accept(listener);
            }
            catch (Throwable x) {
                LOG.info("Exception while invoking listener {}", (Object)listener, (Object)x);
            }
        }
    }

    @Override
    public Duration getIdleTimeout() {
        return this.configurationCustomizer.getIdleTimeout();
    }

    @Override
    public void setIdleTimeout(Duration duration) {
        this.configurationCustomizer.setIdleTimeout(duration);
        this.getHttpClient().setIdleTimeout(duration.toMillis());
    }

    @Override
    public int getInputBufferSize() {
        return this.configurationCustomizer.getInputBufferSize();
    }

    @Override
    public void setInputBufferSize(int size) {
        this.configurationCustomizer.setInputBufferSize(size);
    }

    @Override
    public int getOutputBufferSize() {
        return this.configurationCustomizer.getOutputBufferSize();
    }

    @Override
    public void setOutputBufferSize(int size) {
        this.configurationCustomizer.setOutputBufferSize(size);
    }

    @Override
    public long getMaxBinaryMessageSize() {
        return this.configurationCustomizer.getMaxBinaryMessageSize();
    }

    @Override
    public void setMaxBinaryMessageSize(long size) {
        this.configurationCustomizer.setMaxBinaryMessageSize(size);
    }

    @Override
    public long getMaxTextMessageSize() {
        return this.configurationCustomizer.getMaxTextMessageSize();
    }

    @Override
    public void setMaxTextMessageSize(long size) {
        this.configurationCustomizer.setMaxTextMessageSize(size);
    }

    @Override
    public long getMaxFrameSize() {
        return this.configurationCustomizer.getMaxFrameSize();
    }

    @Override
    public void setMaxFrameSize(long maxFrameSize) {
        this.configurationCustomizer.setMaxFrameSize(maxFrameSize);
    }

    @Override
    public boolean isAutoFragment() {
        return this.configurationCustomizer.isAutoFragment();
    }

    @Override
    public void setAutoFragment(boolean autoFragment) {
        this.configurationCustomizer.setAutoFragment(autoFragment);
    }

    @Override
    public int getMaxOutgoingFrames() {
        return this.configurationCustomizer.getMaxOutgoingFrames();
    }

    @Override
    public void setMaxOutgoingFrames(int maxOutgoingFrames) {
        this.configurationCustomizer.setMaxOutgoingFrames(maxOutgoingFrames);
    }

    public SocketAddress getBindAddress() {
        return this.getHttpClient().getBindAddress();
    }

    public void setBindAddress(SocketAddress bindAddress) {
        this.getHttpClient().setBindAddress(bindAddress);
    }

    public long getConnectTimeout() {
        return this.getHttpClient().getConnectTimeout();
    }

    public void setConnectTimeout(long ms) {
        this.getHttpClient().setConnectTimeout(ms);
    }

    @Override
    public Executor getExecutor() {
        return this.getHttpClient().getExecutor();
    }

    public HttpClient getHttpClient() {
        return this.coreClient.getHttpClient();
    }

    public DecoratedObjectFactory getObjectFactory() {
        return this.coreClient.getObjectFactory();
    }

    @Override
    public Collection<Session> getOpenSessions() {
        return this.sessionTracker.getSessions();
    }

    public SslContextFactory getSslContextFactory() {
        return this.getHttpClient().getSslContextFactory();
    }

    public void setStopAtShutdown(boolean stop) {
        if (stop) {
            if (!this.stopAtShutdown && !ShutdownThread.isRegistered(this)) {
                ShutdownThread.register(this);
            }
        } else {
            ShutdownThread.deregister(this);
        }
        this.stopAtShutdown = stop;
    }

    public void setStopTimeout(long stopTimeout) {
        this._stopTimeout = stopTimeout;
    }

    public long getStopTimeout() {
        return this._stopTimeout;
    }

    public boolean isStopAtShutdown() {
        return this.stopAtShutdown;
    }

    @Override
    protected void doStop() throws Exception {
        if (this.getStopTimeout() > 0L) {
            Graceful.shutdown(this).get(this.getStopTimeout(), TimeUnit.MILLISECONDS);
        }
        super.doStop();
    }

    @Override
    public void close() throws Exception {
        this.stop();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("WebSocketClient@");
        sb.append(Integer.toHexString(this.id));
        sb.append("[coreClient=").append(this.coreClient);
        sb.append(",openSessions.size=");
        sb.append(this.getOpenSessions().size());
        sb.append(']');
        return sb.toString();
    }
}

