/*
 * Decompiled with CFR 0.152.
 */
package com.notium.bettercapes.data;

import com.notium.bettercapes.data.PlayerCapeDataHandler;
import com.notium.bettercapes.data.cape.Cape;
import com.notium.bettercapes.websocket.ConnectionHandler;
import com.notium.bettercapes.websocket.packet.c2s.RequestTabListDataC2SPacket;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class TabListDataHandler {
    private static final TabListDataHandler instance = new TabListDataHandler();
    private final CopyOnWriteArrayList<UUID> dataRequests = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<UUID, Boolean> playerDataHashMap = new ConcurrentHashMap();

    public static TabListDataHandler getInstance() {
        return instance;
    }

    public TabListDataHandler() {
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> {
            if (!this.dataRequests.isEmpty()) {
                List requests = this.dataRequests.stream().toList();
                this.dataRequests.clear();
                int chunkSize = 50;
                for (int i = 0; i < requests.size(); i += chunkSize) {
                    int endIndex = Math.min(i + chunkSize, requests.size());
                    List chunk = requests.subList(i, endIndex);
                    ConnectionHandler.getInstance().sendC2SPacket(new RequestTabListDataC2SPacket(chunk.toArray(new UUID[0])));
                }
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    public void resetData() {
        this.playerDataHashMap.clear();
        this.dataRequests.clear();
    }

    public boolean hasBadge(UUID uuid) {
        if (!this.playerDataHashMap.containsKey(uuid)) {
            if (PlayerCapeDataHandler.getInstance().containsPlayer(uuid) && PlayerCapeDataHandler.getInstance().getPlayerCape((UUID)uuid).type != Cape.CapeType.DEFAULT) {
                this.playerDataHashMap.put(uuid, true);
                return true;
            }
            this.playerDataHashMap.put(uuid, false);
            if (!this.dataRequests.contains(uuid)) {
                this.dataRequests.add(uuid);
            }
        }
        return this.playerDataHashMap.get(uuid);
    }

    public void setPlayerState(UUID uuid, boolean state) {
        this.playerDataHashMap.put(uuid, state);
        this.dataRequests.remove(uuid);
    }
}

