/*
 * Decompiled with CFR 0.152.
 */
package chihalu.hyperfurnace.mixin;

import chihalu.hyperfurnace.furnace.FurnaceSpeedAccessor;
import chihalu.hyperfurnace.furnace.FurnaceSpeedLevels;
import chihalu.hyperfurnace.furnace.FurnaceSpeedPropertyDelegate;
import chihalu.hyperfurnace.storage.StorageCompat;
import net.minecraft.class_1874;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2609;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3866;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2609.class})
public abstract class AbstractFurnaceBlockEntityMixin
implements FurnaceSpeedAccessor {
    private static final String SPEED_KEY = "hyperfurnace_speed";
    @Mutable
    @Shadow(aliases={"field_17374"})
    @Final
    protected class_3913 field_17374;
    @Shadow
    @Final
    private static int field_31291;
    @Shadow
    @Final
    private static int field_31292;
    @Unique
    private int hyperfurnace$speedLevel;
    @Unique
    private int hyperfurnace$baseCookTime;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void hyperfurnace$init(class_2591<?> type, class_2338 pos, class_2680 state, class_3956<? extends class_1874> recipeType, CallbackInfo ci) {
        if (this instanceof class_3866) {
            this.field_17374 = new FurnaceSpeedPropertyDelegate(this.field_17374, this);
        }
    }

    @Inject(method={"writeNbt(Lnet/minecraft/nbt/NbtCompound;Lnet/minecraft/registry/RegistryWrapper$WrapperLookup;)V"}, at={@At(value="TAIL")}, require=0)
    private void hyperfurnace$writeSpeed(class_2487 nbt, class_7225.class_7874 lookup, CallbackInfo ci) {
        if (this instanceof class_3866) {
            StorageCompat.writeInt(nbt, SPEED_KEY, this.hyperfurnace$speedLevel);
        }
    }

    @Inject(method={"readNbt(Lnet/minecraft/nbt/NbtCompound;Lnet/minecraft/registry/RegistryWrapper$WrapperLookup;)V"}, at={@At(value="TAIL")}, require=0)
    private void hyperfurnace$readSpeed(class_2487 nbt, class_7225.class_7874 lookup, CallbackInfo ci) {
        if (this instanceof class_3866) {
            this.hyperfurnace$setSpeedLevelInternal(StorageCompat.readInt(nbt, SPEED_KEY, 0), false);
        }
    }

    @Inject(method={"getCookTime"}, at={@At(value="RETURN")}, cancellable=true, require=0)
    private static void hyperfurnace$adjustCookTime(class_3218 world, class_2609 furnace, CallbackInfoReturnable<Integer> cir) {
        AbstractFurnaceBlockEntityMixin.hyperfurnace$adjustCookTimeCommon(furnace, cir);
    }

    @Inject(method={"method_17029"}, at={@At(value="RETURN")}, cancellable=true, require=0, remap=false)
    private static void hyperfurnace$adjustCookTimeLegacy(class_3218 world, class_2609 furnace, CallbackInfoReturnable<Integer> cir) {
        AbstractFurnaceBlockEntityMixin.hyperfurnace$adjustCookTimeCommon(furnace, cir);
    }

    @Override
    public int hyperfurnace$getSpeedLevel() {
        return this.hyperfurnace$speedLevel;
    }

    @Override
    public void hyperfurnace$setSpeedLevel(int level) {
        if (this instanceof class_3866) {
            this.hyperfurnace$setSpeedLevelInternal(level, true);
        }
    }

    @Override
    public void hyperfurnace$setSpeedLevelFromSync(int level) {
        this.hyperfurnace$setSpeedLevelInternal(level, false);
    }

    @Override
    public void hyperfurnace$setBaseCookTime(int cookTime) {
        this.hyperfurnace$baseCookTime = cookTime;
    }

    @Override
    public int hyperfurnace$getBaseCookTime() {
        return this.hyperfurnace$baseCookTime;
    }

    @Unique
    private void hyperfurnace$setSpeedLevelInternal(int level, boolean markDirty) {
        int clamped = FurnaceSpeedLevels.clamp(level);
        if (clamped == this.hyperfurnace$speedLevel) {
            return;
        }
        int previousSpeed = this.hyperfurnace$speedLevel;
        this.hyperfurnace$speedLevel = clamped;
        int base = this.hyperfurnace$baseCookTime;
        if (base <= 0) {
            base = Math.max(1, Math.round((float)this.hyperfurnace$getCookTimeTotal() * (float)FurnaceSpeedLevels.multiplier(previousSpeed)));
        }
        this.hyperfurnace$baseCookTime = base;
        int newTotal = AbstractFurnaceBlockEntityMixin.hyperfurnace$computeCookTime(base, clamped);
        this.hyperfurnace$applyCookTimeAdjustment(Math.max(1, base), newTotal);
        if (markDirty) {
            ((class_2609)this).method_5431();
        }
    }

    @Unique
    private void hyperfurnace$applyCookTimeAdjustment(int base, int adjusted) {
        int currentTotal = this.hyperfurnace$getCookTimeTotal();
        if (currentTotal == adjusted) {
            return;
        }
        int currentSpent = this.hyperfurnace$getCookTime();
        int scaledSpent = currentTotal > 0 ? class_3532.method_15340((int)((int)Math.round((double)currentSpent * (double)adjusted / (double)currentTotal)), (int)0, (int)adjusted) : currentSpent;
        this.hyperfurnace$setCookTime(scaledSpent);
        this.hyperfurnace$setCookTimeTotal(adjusted);
    }

    @Unique
    private static void hyperfurnace$adjustCookTimeCommon(class_2609 furnace, CallbackInfoReturnable<Integer> cir) {
        if (!(furnace instanceof class_3866)) {
            return;
        }
        int base = Math.max(1, (Integer)cir.getReturnValue());
        FurnaceSpeedAccessor accessor = (FurnaceSpeedAccessor)furnace;
        accessor.hyperfurnace$setBaseCookTime(base);
        int speed = accessor.hyperfurnace$getSpeedLevel();
        int adjusted = AbstractFurnaceBlockEntityMixin.hyperfurnace$computeCookTime(base, speed);
        if (adjusted == base) {
            return;
        }
        cir.setReturnValue((Object)adjusted);
        ((AbstractFurnaceBlockEntityMixin)furnace).hyperfurnace$applyCookTimeAdjustment(base, adjusted);
    }

    @Unique
    private static int hyperfurnace$computeCookTime(int base, int level) {
        int multiplier = FurnaceSpeedLevels.multiplier(level);
        return Math.max(1, (int)Math.ceil((double)base / (double)multiplier));
    }

    @Unique
    private int hyperfurnace$getCookTime() {
        return this.field_17374.method_17390(field_31291);
    }

    @Unique
    private int hyperfurnace$getCookTimeTotal() {
        return this.field_17374.method_17390(field_31292);
    }

    @Unique
    private void hyperfurnace$setCookTime(int value) {
        this.field_17374.method_17391(field_31291, value);
    }

    @Unique
    private void hyperfurnace$setCookTimeTotal(int value) {
        this.field_17374.method_17391(field_31292, value);
    }
}

