/*
 * Decompiled with CFR 0.152.
 */
package chihalu.hyperfurnace.network;

import chihalu.hyperfurnace.furnace.FurnaceScreenHandlerAccess;
import chihalu.hyperfurnace.furnace.FurnaceSpeedAccessor;
import chihalu.hyperfurnace.furnace.FurnaceSpeedLevels;
import chihalu.hyperfurnace.network.payload.SetFurnaceSpeedPayload;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_3222;
import net.minecraft.class_3858;
import net.minecraft.class_3866;

public final class HyperFurnaceNetworking {
    private static boolean registered;

    private HyperFurnaceNetworking() {
    }

    public static void registerCommon() {
        if (registered) {
            return;
        }
        registered = true;
        PayloadTypeRegistry.playC2S().register(SetFurnaceSpeedPayload.ID, SetFurnaceSpeedPayload.CODEC);
    }

    public static void registerServer() {
        HyperFurnaceNetworking.registerCommon();
        ServerPlayNetworking.registerGlobalReceiver(SetFurnaceSpeedPayload.ID, (payload, context) -> HyperFurnaceNetworking.handleSpeedUpdate(context.player(), payload.syncId(), payload.speedLevel()));
    }

    private static void handleSpeedUpdate(class_3222 player, int syncId, int requestedSpeed) {
        if (player.field_7512 == null || player.field_7512.field_7763 != syncId) {
            return;
        }
        class_1703 class_17032 = player.field_7512;
        if (!(class_17032 instanceof class_3858)) {
            return;
        }
        class_3858 furnaceHandler = (class_3858)class_17032;
        int clampedSpeed = FurnaceSpeedLevels.clamp(requestedSpeed);
        FurnaceScreenHandlerAccess access = (FurnaceScreenHandlerAccess)furnaceHandler;
        class_1263 inventory = access.hyperfurnace$getInventory();
        if (inventory instanceof class_3866) {
            class_3866 furnace = (class_3866)inventory;
            ((FurnaceSpeedAccessor)furnace).hyperfurnace$setSpeedLevel(clampedSpeed);
        }
    }
}

