/*
 * Decompiled with CFR 0.152.
 */
package midford.shotbow.item;

import midford.shotbow.entity.SteelArrowEntity;
import midford.shotbow.item.ModItems;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.projectile.ProjectileArrow;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class ShotBowItem
extends Item {
    public ShotBowItem(String translationkey, String namespaceId, int id) {
        super(translationkey, namespaceId, id);
        this.maxStackSize = 1;
        this.setMaxDamage(4608);
    }

    public ItemStack onUseItem(ItemStack itemstack, World world, Player entityplayer) {
        if (entityplayer.inventory.consumeInventoryItem(ModItems.SteelArrow.id)) {
            itemstack.damageItem(1, (Entity)entityplayer);
            world.playSoundAtEntity((Entity)entityplayer, (Entity)entityplayer, "random.bow", 0.3f, 1.0f / (itemRand.nextFloat() * 0.4f + 0.8f));
            if (!world.isClientSide) {
                float spread = 16.0f;
                int shotsToFire = 16;
                for (int i = 0; i < 16; ++i) {
                    SteelArrowEntity arrow = new SteelArrowEntity(world, (Mob)entityplayer, true, 0);
                    float hOff = (itemRand.nextFloat() - 0.5f) * 0.4f;
                    float vOff = (itemRand.nextFloat() - 0.5f) * 0.2f;
                    this.setHeadingDirect(entityplayer, arrow, arrow.xd, arrow.yd, arrow.zd, 1.5f, hOff, vOff);
                    world.entityJoinedWorld((Entity)arrow);
                }
            }
        }
        return itemstack;
    }

    public void setHeadingDirect(Player player, ProjectileArrow arrow, double newMotionX, double newMotionY, double newMotionZ, float speed, float hOff, float vOff) {
        float velocity = MathHelper.sqrt((double)(newMotionX * newMotionX + newMotionY * newMotionY + newMotionZ * newMotionZ));
        float sinYaw = MathHelper.sin((float)(player.yRot * 3.141593f / 180.0f));
        float cosYaw = MathHelper.cos((float)(player.yRot * 3.141593f / 180.0f));
        newMotionX = newMotionX / (double)velocity * (double)speed;
        newMotionY = newMotionY / (double)velocity * (double)speed;
        newMotionZ = newMotionZ / (double)velocity * (double)speed;
        arrow.xd = newMotionX + (double)(hOff * cosYaw);
        arrow.yd = newMotionY + (double)vOff;
        arrow.zd = newMotionZ + (double)(hOff * sinYaw);
        float f3 = MathHelper.sqrt((double)(newMotionX * newMotionX + newMotionZ * newMotionZ));
        arrow.yRotO = arrow.yRot = (float)(Math.atan2(newMotionX, newMotionZ) * 180.0 / Math.PI);
        arrow.xRotO = arrow.xRot = (float)(Math.atan2(newMotionY, f3) * 180.0 / Math.PI);
    }
}

