/*
 * Decompiled with CFR 0.152.
 */
package top.offsetmonkey538.lanwhitelist;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.text2speech.Narrator;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1132;
import net.minecraft.class_11560;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3156;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3340;
import net.minecraft.server.MinecraftServer;
import top.offsetmonkey538.lanwhitelist.LANWhitelist;
import top.offsetmonkey538.lanwhitelist.config.WhitelistEnabled;

@Environment(value=EnvType.CLIENT)
public class LANWhitelistClient
implements ClientModInitializer {
    public void onInitializeClient() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            if (!(server instanceof class_1132)) {
                LANWhitelist.logServer();
                return;
            }
            class_1132 integratedServer = (class_1132)server;
            boolean enabled = WhitelistEnabled.isWhitelistEnabled(integratedServer);
            server.method_73589(enabled);
            server.method_3731(enabled);
            try {
                server.method_3760().method_14590().method_14630();
            }
            catch (IOException e) {
                Narrator.LOGGER.warn("Failed to load white-list: ", (Throwable)e);
            }
            server.method_3760().method_14590().method_74008(new class_3340(new class_11560(integratedServer.method_43824())));
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, commandRegistryAccess, registrationEnvironment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"whitelist").requires(source -> {
            class_1657 player;
            MinecraftServer patt0$temp = source.method_9211();
            if (!(patt0$temp instanceof class_1132)) {
                LANWhitelist.logServer();
                return false;
            }
            class_1132 server = (class_1132)patt0$temp;
            class_1297 patt1$temp = source.method_9228();
            return patt1$temp instanceof class_1657 && server.method_19466((player = (class_1657)patt1$temp).method_72498());
        })).then(class_2170.method_9247((String)"on").executes(context -> {
            MinecraftServer patt0$temp = ((class_2168)context.getSource()).method_9211();
            if (!(patt0$temp instanceof class_1132)) {
                LANWhitelist.logServer();
                return 0;
            }
            class_1132 server = (class_1132)patt0$temp;
            server.method_3760().method_14590().method_74008(new class_3340(new class_11560(server.method_43824())));
            return class_3156.method_13839((class_2168)((class_2168)context.getSource()));
        }))).then(class_2170.method_9247((String)"off").executes(context -> class_3156.method_13837((class_2168)((class_2168)context.getSource()))))).then(class_2170.method_9247((String)"list").executes(context -> class_3156.method_13840((class_2168)((class_2168)context.getSource()))))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2191.method_9329()).suggests((context, builder) -> {
            class_3324 playerManager = ((class_2168)context.getSource()).method_9211().method_3760();
            return class_2172.method_9264(playerManager.method_14571().stream().filter(player -> !playerManager.method_14590().method_14653(player.method_72498())).map(player -> player.method_7334().name()), (SuggestionsBuilder)builder);
        }).executes(context -> class_3156.method_13838((class_2168)((class_2168)context.getSource()), (Collection)class_2191.method_9330((CommandContext)context, (String)"targets")))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2191.method_9329()).suggests((context, builder) -> class_2172.method_9253((String[])((class_2168)context.getSource()).method_9211().method_3760().method_14560(), (SuggestionsBuilder)builder)).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            Collection targets = class_2191.method_9330((CommandContext)context, (String)"targets");
            MinecraftServer patt0$temp = source.method_9211();
            if (!(patt0$temp instanceof class_1132)) {
                return LANWhitelist.logServer(-1);
            }
            class_1132 server = (class_1132)patt0$temp;
            LinkedList<class_11560> newTargets = new LinkedList<class_11560>();
            for (class_11560 profile : targets) {
                if (!server.method_19466(profile)) {
                    newTargets.add(profile);
                    continue;
                }
                source.method_9226(() -> class_2561.method_43469((String)"commands.lan_whitelist.whitelist.remove.host", (Object[])new Object[]{profile.comp_4423()}).method_27692(class_124.field_1061), true);
            }
            if (newTargets.isEmpty()) {
                return 1;
            }
            return class_3156.method_13845((class_2168)source, newTargets);
        })))).then(class_2170.method_9247((String)"reload").executes(context -> {
            MinecraftServer patt0$temp = ((class_2168)context.getSource()).method_9211();
            if (!(patt0$temp instanceof class_1132)) {
                LANWhitelist.logServer();
                return 0;
            }
            class_1132 server = (class_1132)patt0$temp;
            server.method_3760().method_14590().method_74008(new class_3340(new class_11560(server.method_43824())));
            boolean enabled = WhitelistEnabled.isWhitelistEnabled(server);
            server.method_73589(enabled);
            server.method_3731(enabled);
            LANWhitelistClient.sendEnabledMessageToHost(server, enabled);
            return class_3156.method_13850((class_2168)((class_2168)context.getSource()));
        }))));
    }

    public static void sendEnabledMessageToHost(class_1132 server, boolean enabled) {
        GameProfile hostProfile = server.method_43824();
        if (hostProfile == null) {
            throw new IllegalStateException("Host player profile not set!");
        }
        class_3222 hostPlayer = server.method_3760().method_14602(hostProfile.id());
        if (hostPlayer == null) {
            throw new IllegalStateException("Host player not in server???");
        }
        hostPlayer.method_7353((class_2561)class_2561.method_43471((String)(enabled ? "lan-whitelist.enabled" : "lan-whitelist.disabled")).method_27692(class_124.field_1054), false);
    }
}

