/*
 * Decompiled with CFR 0.152.
 */
package top.offsetmonkey538.lanwhitelist.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1132;
import net.minecraft.class_5218;
import top.offsetmonkey538.lanwhitelist.LANWhitelist;

@Environment(value=EnvType.CLIENT)
public final class WhitelistEnabled {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    private WhitelistEnabled() {
    }

    public static boolean isWhitelistEnabled(class_1132 server) {
        try {
            return ((JsonData)GSON.fromJson((Reader)Files.newBufferedReader(WhitelistEnabled.getSavePath(server)), JsonData.class)).enabled();
        }
        catch (IOException e) {
            LANWhitelist.LOGGER.error("Failed to load whitelist enabled file! Whitelist will be disabled.", (Throwable)e);
            return false;
        }
    }

    public static void setWhitelistEnabled(class_1132 server, boolean enabled) {
        try {
            Path savePath = WhitelistEnabled.getSavePath(server);
            Files.createDirectories(savePath.getParent(), new FileAttribute[0]);
            Files.writeString(savePath, (CharSequence)GSON.toJson((Object)new JsonData(enabled)), new OpenOption[0]);
        }
        catch (IOException e) {
            LANWhitelist.LOGGER.error("Failed to write whitelist enabled file!", (Throwable)e);
        }
    }

    private static Path getSavePath(class_1132 server) {
        return server.method_27050(class_5218.field_24188).resolve("lan-whitelist").resolve("enabled.json");
    }

    @Environment(value=EnvType.CLIENT)
    private record JsonData(boolean enabled) {
    }
}

